/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.DataAccessAuthMode;
import com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.azure.resourcemanager.compute.models.DiskState;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PropertyUpdatesInProgress;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.ShareInfoElement;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DiskProperties
implements JsonSerializable<DiskProperties> {
    private OffsetDateTime timeCreated;
    private OperatingSystemTypes osType;
    private HyperVGeneration hyperVGeneration;
    private PurchasePlanAutoGenerated purchasePlan;
    private SupportedCapabilities supportedCapabilities;
    private CreationData creationData;
    private Integer diskSizeGB;
    private Long diskSizeBytes;
    private String uniqueId;
    private EncryptionSettingsCollection encryptionSettingsCollection;
    private String provisioningState;
    private Long diskIopsReadWrite;
    private Long diskMBpsReadWrite;
    private Long diskIopsReadOnly;
    private Long diskMBpsReadOnly;
    private DiskState diskState;
    private Encryption encryption;
    private Integer maxShares;
    private List<ShareInfoElement> shareInfo;
    private NetworkAccessPolicy networkAccessPolicy;
    private String diskAccessId;
    private OffsetDateTime burstingEnabledTime;
    private String tier;
    private Boolean burstingEnabled;
    private PropertyUpdatesInProgress propertyUpdatesInProgress;
    private Boolean supportsHibernation;
    private DiskSecurityProfile securityProfile;
    private Float completionPercent;
    private PublicNetworkAccess publicNetworkAccess;
    private DataAccessAuthMode dataAccessAuthMode;
    private Boolean optimizedForFrequentAttach;
    private OffsetDateTime lastOwnershipUpdateTime;
    private static final ClientLogger LOGGER = new ClientLogger(DiskProperties.class);

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public DiskProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public DiskProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public DiskProperties withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public DiskProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    public CreationData creationData() {
        return this.creationData;
    }

    public DiskProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public DiskProperties withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Long diskSizeBytes() {
        return this.diskSizeBytes;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public DiskProperties withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    public DiskProperties withDiskIopsReadWrite(Long diskIopsReadWrite) {
        this.diskIopsReadWrite = diskIopsReadWrite;
        return this;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public DiskProperties withDiskMBpsReadWrite(Long diskMBpsReadWrite) {
        this.diskMBpsReadWrite = diskMBpsReadWrite;
        return this;
    }

    public Long diskIopsReadOnly() {
        return this.diskIopsReadOnly;
    }

    public DiskProperties withDiskIopsReadOnly(Long diskIopsReadOnly) {
        this.diskIopsReadOnly = diskIopsReadOnly;
        return this;
    }

    public Long diskMBpsReadOnly() {
        return this.diskMBpsReadOnly;
    }

    public DiskProperties withDiskMBpsReadOnly(Long diskMBpsReadOnly) {
        this.diskMBpsReadOnly = diskMBpsReadOnly;
        return this;
    }

    public DiskState diskState() {
        return this.diskState;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public DiskProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public Integer maxShares() {
        return this.maxShares;
    }

    public DiskProperties withMaxShares(Integer maxShares) {
        this.maxShares = maxShares;
        return this;
    }

    public List<ShareInfoElement> shareInfo() {
        return this.shareInfo;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public DiskProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public DiskProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public OffsetDateTime burstingEnabledTime() {
        return this.burstingEnabledTime;
    }

    public String tier() {
        return this.tier;
    }

    public DiskProperties withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public Boolean burstingEnabled() {
        return this.burstingEnabled;
    }

    public DiskProperties withBurstingEnabled(Boolean burstingEnabled) {
        this.burstingEnabled = burstingEnabled;
        return this;
    }

    public PropertyUpdatesInProgress propertyUpdatesInProgress() {
        return this.propertyUpdatesInProgress;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public DiskProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public DiskProperties withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public Float completionPercent() {
        return this.completionPercent;
    }

    public DiskProperties withCompletionPercent(Float completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DiskProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public DataAccessAuthMode dataAccessAuthMode() {
        return this.dataAccessAuthMode;
    }

    public DiskProperties withDataAccessAuthMode(DataAccessAuthMode dataAccessAuthMode) {
        this.dataAccessAuthMode = dataAccessAuthMode;
        return this;
    }

    public Boolean optimizedForFrequentAttach() {
        return this.optimizedForFrequentAttach;
    }

    public DiskProperties withOptimizedForFrequentAttach(Boolean optimizedForFrequentAttach) {
        this.optimizedForFrequentAttach = optimizedForFrequentAttach;
        return this;
    }

    public OffsetDateTime lastOwnershipUpdateTime() {
        return this.lastOwnershipUpdateTime;
    }

    public void validate() {
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.supportedCapabilities() != null) {
            this.supportedCapabilities().validate();
        }
        if (this.creationData() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property creationData in model DiskProperties"));
        }
        this.creationData().validate();
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.shareInfo() != null) {
            this.shareInfo().forEach(e -> e.validate());
        }
        if (this.propertyUpdatesInProgress() != null) {
            this.propertyUpdatesInProgress().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("creationData", (JsonSerializable)this.creationData);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeJsonField("purchasePlan", (JsonSerializable)this.purchasePlan);
        jsonWriter.writeJsonField("supportedCapabilities", (JsonSerializable)this.supportedCapabilities);
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeJsonField("encryptionSettingsCollection", (JsonSerializable)this.encryptionSettingsCollection);
        jsonWriter.writeNumberField("diskIOPSReadWrite", (Number)this.diskIopsReadWrite);
        jsonWriter.writeNumberField("diskMBpsReadWrite", (Number)this.diskMBpsReadWrite);
        jsonWriter.writeNumberField("diskIOPSReadOnly", (Number)this.diskIopsReadOnly);
        jsonWriter.writeNumberField("diskMBpsReadOnly", (Number)this.diskMBpsReadOnly);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeNumberField("maxShares", (Number)this.maxShares);
        jsonWriter.writeStringField("networkAccessPolicy", this.networkAccessPolicy == null ? null : this.networkAccessPolicy.toString());
        jsonWriter.writeStringField("diskAccessId", this.diskAccessId);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeBooleanField("burstingEnabled", this.burstingEnabled);
        jsonWriter.writeBooleanField("supportsHibernation", this.supportsHibernation);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeNumberField("completionPercent", (Number)this.completionPercent);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("dataAccessAuthMode", this.dataAccessAuthMode == null ? null : this.dataAccessAuthMode.toString());
        jsonWriter.writeBooleanField("optimizedForFrequentAttach", this.optimizedForFrequentAttach);
        return jsonWriter.writeEndObject();
    }

    public static DiskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiskProperties)jsonReader.readObject(reader -> {
            DiskProperties deserializedDiskProperties = new DiskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationData".equals(fieldName)) {
                    deserializedDiskProperties.creationData = CreationData.fromJson(reader);
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedDiskProperties.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedDiskProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedDiskProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                if ("purchasePlan".equals(fieldName)) {
                    deserializedDiskProperties.purchasePlan = PurchasePlanAutoGenerated.fromJson(reader);
                    continue;
                }
                if ("supportedCapabilities".equals(fieldName)) {
                    deserializedDiskProperties.supportedCapabilities = SupportedCapabilities.fromJson(reader);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedDiskProperties.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("diskSizeBytes".equals(fieldName)) {
                    deserializedDiskProperties.diskSizeBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("uniqueId".equals(fieldName)) {
                    deserializedDiskProperties.uniqueId = reader.getString();
                    continue;
                }
                if ("encryptionSettingsCollection".equals(fieldName)) {
                    deserializedDiskProperties.encryptionSettingsCollection = EncryptionSettingsCollection.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDiskProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("diskIOPSReadWrite".equals(fieldName)) {
                    deserializedDiskProperties.diskIopsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskMBpsReadWrite".equals(fieldName)) {
                    deserializedDiskProperties.diskMBpsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskIOPSReadOnly".equals(fieldName)) {
                    deserializedDiskProperties.diskIopsReadOnly = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskMBpsReadOnly".equals(fieldName)) {
                    deserializedDiskProperties.diskMBpsReadOnly = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskState".equals(fieldName)) {
                    deserializedDiskProperties.diskState = DiskState.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedDiskProperties.encryption = Encryption.fromJson(reader);
                    continue;
                }
                if ("maxShares".equals(fieldName)) {
                    deserializedDiskProperties.maxShares = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("shareInfo".equals(fieldName)) {
                    List shareInfo;
                    deserializedDiskProperties.shareInfo = shareInfo = reader.readArray(reader1 -> ShareInfoElement.fromJson(reader1));
                    continue;
                }
                if ("networkAccessPolicy".equals(fieldName)) {
                    deserializedDiskProperties.networkAccessPolicy = NetworkAccessPolicy.fromString(reader.getString());
                    continue;
                }
                if ("diskAccessId".equals(fieldName)) {
                    deserializedDiskProperties.diskAccessId = reader.getString();
                    continue;
                }
                if ("burstingEnabledTime".equals(fieldName)) {
                    deserializedDiskProperties.burstingEnabledTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedDiskProperties.tier = reader.getString();
                    continue;
                }
                if ("burstingEnabled".equals(fieldName)) {
                    deserializedDiskProperties.burstingEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("propertyUpdatesInProgress".equals(fieldName)) {
                    deserializedDiskProperties.propertyUpdatesInProgress = PropertyUpdatesInProgress.fromJson(reader);
                    continue;
                }
                if ("supportsHibernation".equals(fieldName)) {
                    deserializedDiskProperties.supportsHibernation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedDiskProperties.securityProfile = DiskSecurityProfile.fromJson(reader);
                    continue;
                }
                if ("completionPercent".equals(fieldName)) {
                    deserializedDiskProperties.completionPercent = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDiskProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("dataAccessAuthMode".equals(fieldName)) {
                    deserializedDiskProperties.dataAccessAuthMode = DataAccessAuthMode.fromString(reader.getString());
                    continue;
                }
                if ("optimizedForFrequentAttach".equals(fieldName)) {
                    deserializedDiskProperties.optimizedForFrequentAttach = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("LastOwnershipUpdateTime".equals(fieldName)) {
                    deserializedDiskProperties.lastOwnershipUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskProperties;
        });
    }
}

