// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * List of supported capabilities persisted on the disk resource for VM use.
 */
@Fluent
public final class SupportedCapabilities implements JsonSerializable<SupportedCapabilities> {
    /*
     * The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI.
     */
    private String diskControllerTypes;

    /*
     * True if the image from which the OS disk is created supports accelerated networking.
     */
    private Boolean acceleratedNetwork;

    /*
     * CPU architecture supported by an OS disk.
     */
    private Architecture architecture;

    /**
     * Creates an instance of SupportedCapabilities class.
     */
    public SupportedCapabilities() {
    }

    /**
     * Get the diskControllerTypes property: The disk controllers that an OS disk supports. If set it can be SCSI or
     * SCSI, NVME or NVME, SCSI.
     * 
     * @return the diskControllerTypes value.
     */
    public String diskControllerTypes() {
        return this.diskControllerTypes;
    }

    /**
     * Set the diskControllerTypes property: The disk controllers that an OS disk supports. If set it can be SCSI or
     * SCSI, NVME or NVME, SCSI.
     * 
     * @param diskControllerTypes the diskControllerTypes value to set.
     * @return the SupportedCapabilities object itself.
     */
    public SupportedCapabilities withDiskControllerTypes(String diskControllerTypes) {
        this.diskControllerTypes = diskControllerTypes;
        return this;
    }

    /**
     * Get the acceleratedNetwork property: True if the image from which the OS disk is created supports accelerated
     * networking.
     * 
     * @return the acceleratedNetwork value.
     */
    public Boolean acceleratedNetwork() {
        return this.acceleratedNetwork;
    }

    /**
     * Set the acceleratedNetwork property: True if the image from which the OS disk is created supports accelerated
     * networking.
     * 
     * @param acceleratedNetwork the acceleratedNetwork value to set.
     * @return the SupportedCapabilities object itself.
     */
    public SupportedCapabilities withAcceleratedNetwork(Boolean acceleratedNetwork) {
        this.acceleratedNetwork = acceleratedNetwork;
        return this;
    }

    /**
     * Get the architecture property: CPU architecture supported by an OS disk.
     * 
     * @return the architecture value.
     */
    public Architecture architecture() {
        return this.architecture;
    }

    /**
     * Set the architecture property: CPU architecture supported by an OS disk.
     * 
     * @param architecture the architecture value to set.
     * @return the SupportedCapabilities object itself.
     */
    public SupportedCapabilities withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskControllerTypes", this.diskControllerTypes);
        jsonWriter.writeBooleanField("acceleratedNetwork", this.acceleratedNetwork);
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SupportedCapabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SupportedCapabilities if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SupportedCapabilities.
     */
    public static SupportedCapabilities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SupportedCapabilities deserializedSupportedCapabilities = new SupportedCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskControllerTypes".equals(fieldName)) {
                    deserializedSupportedCapabilities.diskControllerTypes = reader.getString();
                } else if ("acceleratedNetwork".equals(fieldName)) {
                    deserializedSupportedCapabilities.acceleratedNetwork = reader.getNullable(JsonReader::getBoolean);
                } else if ("architecture".equals(fieldName)) {
                    deserializedSupportedCapabilities.architecture = Architecture.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSupportedCapabilities;
        });
    }
}
