// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The instance view of a restore point.
 */
@Fluent
public final class RestorePointInstanceView implements JsonSerializable<RestorePointInstanceView> {
    /*
     * The disk restore points information.
     */
    private List<DiskRestorePointInstanceView> diskRestorePoints;

    /*
     * The resource status information.
     */
    private List<InstanceViewStatus> statuses;

    /**
     * Creates an instance of RestorePointInstanceView class.
     */
    public RestorePointInstanceView() {
    }

    /**
     * Get the diskRestorePoints property: The disk restore points information.
     * 
     * @return the diskRestorePoints value.
     */
    public List<DiskRestorePointInstanceView> diskRestorePoints() {
        return this.diskRestorePoints;
    }

    /**
     * Set the diskRestorePoints property: The disk restore points information.
     * 
     * @param diskRestorePoints the diskRestorePoints value to set.
     * @return the RestorePointInstanceView object itself.
     */
    public RestorePointInstanceView withDiskRestorePoints(List<DiskRestorePointInstanceView> diskRestorePoints) {
        this.diskRestorePoints = diskRestorePoints;
        return this;
    }

    /**
     * Get the statuses property: The resource status information.
     * 
     * @return the statuses value.
     */
    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    /**
     * Set the statuses property: The resource status information.
     * 
     * @param statuses the statuses value to set.
     * @return the RestorePointInstanceView object itself.
     */
    public RestorePointInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskRestorePoints() != null) {
            diskRestorePoints().forEach(e -> e.validate());
        }
        if (statuses() != null) {
            statuses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("diskRestorePoints", this.diskRestorePoints,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorePointInstanceView from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorePointInstanceView if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorePointInstanceView.
     */
    public static RestorePointInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorePointInstanceView deserializedRestorePointInstanceView = new RestorePointInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskRestorePoints".equals(fieldName)) {
                    List<DiskRestorePointInstanceView> diskRestorePoints
                        = reader.readArray(reader1 -> DiskRestorePointInstanceView.fromJson(reader1));
                    deserializedRestorePointInstanceView.diskRestorePoints = diskRestorePoints;
                } else if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses
                        = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedRestorePointInstanceView.statuses = statuses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorePointInstanceView;
        });
    }
}
