// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * This is the safety profile of the Gallery Artifact Version.
 */
@Fluent
public class GalleryArtifactSafetyProfileBase implements JsonSerializable<GalleryArtifactSafetyProfileBase> {
    /*
     * Indicates whether or not removing this Gallery Image Version from replicated regions is allowed.
     */
    private Boolean allowDeletionOfReplicatedLocations;

    /**
     * Creates an instance of GalleryArtifactSafetyProfileBase class.
     */
    public GalleryArtifactSafetyProfileBase() {
    }

    /**
     * Get the allowDeletionOfReplicatedLocations property: Indicates whether or not removing this Gallery Image Version
     * from replicated regions is allowed.
     * 
     * @return the allowDeletionOfReplicatedLocations value.
     */
    public Boolean allowDeletionOfReplicatedLocations() {
        return this.allowDeletionOfReplicatedLocations;
    }

    /**
     * Set the allowDeletionOfReplicatedLocations property: Indicates whether or not removing this Gallery Image Version
     * from replicated regions is allowed.
     * 
     * @param allowDeletionOfReplicatedLocations the allowDeletionOfReplicatedLocations value to set.
     * @return the GalleryArtifactSafetyProfileBase object itself.
     */
    public GalleryArtifactSafetyProfileBase
        withAllowDeletionOfReplicatedLocations(Boolean allowDeletionOfReplicatedLocations) {
        this.allowDeletionOfReplicatedLocations = allowDeletionOfReplicatedLocations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowDeletionOfReplicatedLocations", this.allowDeletionOfReplicatedLocations);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryArtifactSafetyProfileBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryArtifactSafetyProfileBase if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryArtifactSafetyProfileBase.
     */
    public static GalleryArtifactSafetyProfileBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryArtifactSafetyProfileBase deserializedGalleryArtifactSafetyProfileBase
                = new GalleryArtifactSafetyProfileBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowDeletionOfReplicatedLocations".equals(fieldName)) {
                    deserializedGalleryArtifactSafetyProfileBase.allowDeletionOfReplicatedLocations
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryArtifactSafetyProfileBase;
        });
    }
}
