// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryApplicationVersionProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Specifies information about the gallery Application Version that you want to update.
 */
@Fluent
public final class GalleryApplicationVersionUpdate extends UpdateResourceDefinition {
    /*
     * Describes the properties of a gallery image version.
     */
    private GalleryApplicationVersionProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GalleryApplicationVersionUpdate class.
     */
    public GalleryApplicationVersionUpdate() {
    }

    /**
     * Get the innerProperties property: Describes the properties of a gallery image version.
     * 
     * @return the innerProperties value.
     */
    private GalleryApplicationVersionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryApplicationVersionUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the publishingProfile property: The publishing profile of a gallery image version.
     * 
     * @return the publishingProfile value.
     */
    public GalleryApplicationVersionPublishingProfile publishingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingProfile();
    }

    /**
     * Set the publishingProfile property: The publishing profile of a gallery image version.
     * 
     * @param publishingProfile the publishingProfile value to set.
     * @return the GalleryApplicationVersionUpdate object itself.
     */
    public GalleryApplicationVersionUpdate
        withPublishingProfile(GalleryApplicationVersionPublishingProfile publishingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryApplicationVersionProperties();
        }
        this.innerProperties().withPublishingProfile(publishingProfile);
        return this;
    }

    /**
     * Get the safetyProfile property: The safety profile of the Gallery Application Version.
     * 
     * @return the safetyProfile value.
     */
    public GalleryApplicationVersionSafetyProfile safetyProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().safetyProfile();
    }

    /**
     * Set the safetyProfile property: The safety profile of the Gallery Application Version.
     * 
     * @param safetyProfile the safetyProfile value to set.
     * @return the GalleryApplicationVersionUpdate object itself.
     */
    public GalleryApplicationVersionUpdate withSafetyProfile(GalleryApplicationVersionSafetyProfile safetyProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryApplicationVersionProperties();
        }
        this.innerProperties().withSafetyProfile(safetyProfile);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryApplicationVersionUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryApplicationVersionUpdate if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryApplicationVersionUpdate.
     */
    public static GalleryApplicationVersionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryApplicationVersionUpdate deserializedGalleryApplicationVersionUpdate
                = new GalleryApplicationVersionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGalleryApplicationVersionUpdate.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGalleryApplicationVersionUpdate.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryApplicationVersionUpdate.type = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryApplicationVersionUpdate.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGalleryApplicationVersionUpdate.innerProperties
                        = GalleryApplicationVersionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryApplicationVersionUpdate;
        });
    }
}
