// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * This property allows you to specify whether the access control rules are in Audit mode, in Enforce mode or Disabled.
 * Possible values are: 'Audit', 'Enforce' or 'Disabled'.
 */
public final class AccessControlRulesMode extends ExpandableStringEnum<AccessControlRulesMode> {
    /**
     * Static value Audit for AccessControlRulesMode.
     */
    public static final AccessControlRulesMode AUDIT = fromString("Audit");

    /**
     * Static value Enforce for AccessControlRulesMode.
     */
    public static final AccessControlRulesMode ENFORCE = fromString("Enforce");

    /**
     * Static value Disabled for AccessControlRulesMode.
     */
    public static final AccessControlRulesMode DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of AccessControlRulesMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AccessControlRulesMode() {
    }

    /**
     * Creates or finds a AccessControlRulesMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AccessControlRulesMode.
     */
    public static AccessControlRulesMode fromString(String name) {
        return fromString(name, AccessControlRulesMode.class);
    }

    /**
     * Gets known AccessControlRulesMode values.
     * 
     * @return known AccessControlRulesMode values.
     */
    public static Collection<AccessControlRulesMode> values() {
        return values(AccessControlRulesMode.class);
    }
}
