/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.Mode;
import java.io.IOException;

public final class ProxyAgentSettings
implements JsonSerializable<ProxyAgentSettings> {
    private Boolean enabled;
    private Mode mode;
    private Integer keyIncarnationId;

    public Boolean enabled() {
        return this.enabled;
    }

    public ProxyAgentSettings withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Mode mode() {
        return this.mode;
    }

    public ProxyAgentSettings withMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Integer keyIncarnationId() {
        return this.keyIncarnationId;
    }

    public ProxyAgentSettings withKeyIncarnationId(Integer keyIncarnationId) {
        this.keyIncarnationId = keyIncarnationId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeNumberField("keyIncarnationId", (Number)this.keyIncarnationId);
        return jsonWriter.writeEndObject();
    }

    public static ProxyAgentSettings fromJson(JsonReader jsonReader) throws IOException {
        return (ProxyAgentSettings)jsonReader.readObject(reader -> {
            ProxyAgentSettings deserializedProxyAgentSettings = new ProxyAgentSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedProxyAgentSettings.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedProxyAgentSettings.mode = Mode.fromString(reader.getString());
                    continue;
                }
                if ("keyIncarnationId".equals(fieldName)) {
                    deserializedProxyAgentSettings.keyIncarnationId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProxyAgentSettings;
        });
    }
}

