// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies a list of virtual machine instance IDs from the VM scale set.
 */
@Fluent
public final class VirtualMachineScaleSetVMInstanceIDs
    implements JsonSerializable<VirtualMachineScaleSetVMInstanceIDs> {
    /*
     * The virtual machine scale set instance ids. Omitting the virtual machine scale set instance ids will result in
     * the operation being performed on all virtual machines in the virtual machine scale set.
     */
    private List<String> instanceIds;

    /**
     * Creates an instance of VirtualMachineScaleSetVMInstanceIDs class.
     */
    public VirtualMachineScaleSetVMInstanceIDs() {
    }

    /**
     * Get the instanceIds property: The virtual machine scale set instance ids. Omitting the virtual machine scale set
     * instance ids will result in the operation being performed on all virtual machines in the virtual machine scale
     * set.
     * 
     * @return the instanceIds value.
     */
    public List<String> instanceIds() {
        return this.instanceIds;
    }

    /**
     * Set the instanceIds property: The virtual machine scale set instance ids. Omitting the virtual machine scale set
     * instance ids will result in the operation being performed on all virtual machines in the virtual machine scale
     * set.
     * 
     * @param instanceIds the instanceIds value to set.
     * @return the VirtualMachineScaleSetVMInstanceIDs object itself.
     */
    public VirtualMachineScaleSetVMInstanceIDs withInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("instanceIds", this.instanceIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetVMInstanceIDs from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetVMInstanceIDs if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetVMInstanceIDs.
     */
    public static VirtualMachineScaleSetVMInstanceIDs fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMInstanceIDs deserializedVirtualMachineScaleSetVMInstanceIDs
                = new VirtualMachineScaleSetVMInstanceIDs();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("instanceIds".equals(fieldName)) {
                    List<String> instanceIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedVirtualMachineScaleSetVMInstanceIDs.instanceIds = instanceIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetVMInstanceIDs;
        });
    }
}
