// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Extensions summary for virtual machines of a virtual machine scale set.
 */
@Immutable
public final class VirtualMachineScaleSetVMExtensionsSummary
    implements JsonSerializable<VirtualMachineScaleSetVMExtensionsSummary> {
    /*
     * The extension name.
     */
    private String name;

    /*
     * The extensions information.
     */
    private List<VirtualMachineStatusCodeCount> statusesSummary;

    /**
     * Creates an instance of VirtualMachineScaleSetVMExtensionsSummary class.
     */
    public VirtualMachineScaleSetVMExtensionsSummary() {
    }

    /**
     * Get the name property: The extension name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the statusesSummary property: The extensions information.
     * 
     * @return the statusesSummary value.
     */
    public List<VirtualMachineStatusCodeCount> statusesSummary() {
        return this.statusesSummary;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (statusesSummary() != null) {
            statusesSummary().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetVMExtensionsSummary from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetVMExtensionsSummary if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetVMExtensionsSummary.
     */
    public static VirtualMachineScaleSetVMExtensionsSummary fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMExtensionsSummary deserializedVirtualMachineScaleSetVMExtensionsSummary
                = new VirtualMachineScaleSetVMExtensionsSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMExtensionsSummary.name = reader.getString();
                } else if ("statusesSummary".equals(fieldName)) {
                    List<VirtualMachineStatusCodeCount> statusesSummary
                        = reader.readArray(reader1 -> VirtualMachineStatusCodeCount.fromJson(reader1));
                    deserializedVirtualMachineScaleSetVMExtensionsSummary.statusesSummary = statusesSummary;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetVMExtensionsSummary;
        });
    }
}
