// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a virtual machine scale set OS profile.
 */
@Fluent
public final class VirtualMachineScaleSetUpdateOSProfile
    implements JsonSerializable<VirtualMachineScaleSetUpdateOSProfile> {
    /*
     * A base-64 encoded string of custom data.
     */
    private String customData;

    /*
     * The Windows Configuration of the OS profile.
     */
    private WindowsConfiguration windowsConfiguration;

    /*
     * The Linux Configuration of the OS profile.
     */
    private LinuxConfiguration linuxConfiguration;

    /*
     * The List of certificates for addition to the VM.
     */
    private List<VaultSecretGroup> secrets;

    /**
     * Creates an instance of VirtualMachineScaleSetUpdateOSProfile class.
     */
    public VirtualMachineScaleSetUpdateOSProfile() {
    }

    /**
     * Get the customData property: A base-64 encoded string of custom data.
     * 
     * @return the customData value.
     */
    public String customData() {
        return this.customData;
    }

    /**
     * Set the customData property: A base-64 encoded string of custom data.
     * 
     * @param customData the customData value to set.
     * @return the VirtualMachineScaleSetUpdateOSProfile object itself.
     */
    public VirtualMachineScaleSetUpdateOSProfile withCustomData(String customData) {
        this.customData = customData;
        return this;
    }

    /**
     * Get the windowsConfiguration property: The Windows Configuration of the OS profile.
     * 
     * @return the windowsConfiguration value.
     */
    public WindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    /**
     * Set the windowsConfiguration property: The Windows Configuration of the OS profile.
     * 
     * @param windowsConfiguration the windowsConfiguration value to set.
     * @return the VirtualMachineScaleSetUpdateOSProfile object itself.
     */
    public VirtualMachineScaleSetUpdateOSProfile withWindowsConfiguration(WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    /**
     * Get the linuxConfiguration property: The Linux Configuration of the OS profile.
     * 
     * @return the linuxConfiguration value.
     */
    public LinuxConfiguration linuxConfiguration() {
        return this.linuxConfiguration;
    }

    /**
     * Set the linuxConfiguration property: The Linux Configuration of the OS profile.
     * 
     * @param linuxConfiguration the linuxConfiguration value to set.
     * @return the VirtualMachineScaleSetUpdateOSProfile object itself.
     */
    public VirtualMachineScaleSetUpdateOSProfile withLinuxConfiguration(LinuxConfiguration linuxConfiguration) {
        this.linuxConfiguration = linuxConfiguration;
        return this;
    }

    /**
     * Get the secrets property: The List of certificates for addition to the VM.
     * 
     * @return the secrets value.
     */
    public List<VaultSecretGroup> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: The List of certificates for addition to the VM.
     * 
     * @param secrets the secrets value to set.
     * @return the VirtualMachineScaleSetUpdateOSProfile object itself.
     */
    public VirtualMachineScaleSetUpdateOSProfile withSecrets(List<VaultSecretGroup> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (windowsConfiguration() != null) {
            windowsConfiguration().validate();
        }
        if (linuxConfiguration() != null) {
            linuxConfiguration().validate();
        }
        if (secrets() != null) {
            secrets().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customData", this.customData);
        jsonWriter.writeJsonField("windowsConfiguration", this.windowsConfiguration);
        jsonWriter.writeJsonField("linuxConfiguration", this.linuxConfiguration);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetUpdateOSProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetUpdateOSProfile if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetUpdateOSProfile.
     */
    public static VirtualMachineScaleSetUpdateOSProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdateOSProfile deserializedVirtualMachineScaleSetUpdateOSProfile
                = new VirtualMachineScaleSetUpdateOSProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("customData".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSProfile.customData = reader.getString();
                } else if ("windowsConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSProfile.windowsConfiguration
                        = WindowsConfiguration.fromJson(reader);
                } else if ("linuxConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSProfile.linuxConfiguration
                        = LinuxConfiguration.fromJson(reader);
                } else if ("secrets".equals(fieldName)) {
                    List<VaultSecretGroup> secrets = reader.readArray(reader1 -> VaultSecretGroup.fromJson(reader1));
                    deserializedVirtualMachineScaleSetUpdateOSProfile.secrets = secrets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetUpdateOSProfile;
        });
    }
}
