// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The instance view of a virtual machine extension.
 */
@Fluent
public final class VirtualMachineExtensionInstanceView
    implements JsonSerializable<VirtualMachineExtensionInstanceView> {
    /*
     * The virtual machine extension name.
     */
    private String name;

    /*
     * Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    private String type;

    /*
     * Specifies the version of the script handler.
     */
    private String typeHandlerVersion;

    /*
     * The resource status information.
     */
    private List<InstanceViewStatus> substatuses;

    /*
     * The resource status information.
     */
    private List<InstanceViewStatus> statuses;

    /**
     * Creates an instance of VirtualMachineExtensionInstanceView class.
     */
    public VirtualMachineExtensionInstanceView() {
    }

    /**
     * Get the name property: The virtual machine extension name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The virtual machine extension name.
     * 
     * @param name the name value to set.
     * @return the VirtualMachineExtensionInstanceView object itself.
     */
    public VirtualMachineExtensionInstanceView withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Specifies the type of the extension; an example is "CustomScriptExtension".
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Specifies the type of the extension; an example is "CustomScriptExtension".
     * 
     * @param type the type value to set.
     * @return the VirtualMachineExtensionInstanceView object itself.
     */
    public VirtualMachineExtensionInstanceView withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the typeHandlerVersion property: Specifies the version of the script handler.
     * 
     * @return the typeHandlerVersion value.
     */
    public String typeHandlerVersion() {
        return this.typeHandlerVersion;
    }

    /**
     * Set the typeHandlerVersion property: Specifies the version of the script handler.
     * 
     * @param typeHandlerVersion the typeHandlerVersion value to set.
     * @return the VirtualMachineExtensionInstanceView object itself.
     */
    public VirtualMachineExtensionInstanceView withTypeHandlerVersion(String typeHandlerVersion) {
        this.typeHandlerVersion = typeHandlerVersion;
        return this;
    }

    /**
     * Get the substatuses property: The resource status information.
     * 
     * @return the substatuses value.
     */
    public List<InstanceViewStatus> substatuses() {
        return this.substatuses;
    }

    /**
     * Set the substatuses property: The resource status information.
     * 
     * @param substatuses the substatuses value to set.
     * @return the VirtualMachineExtensionInstanceView object itself.
     */
    public VirtualMachineExtensionInstanceView withSubstatuses(List<InstanceViewStatus> substatuses) {
        this.substatuses = substatuses;
        return this;
    }

    /**
     * Get the statuses property: The resource status information.
     * 
     * @return the statuses value.
     */
    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    /**
     * Set the statuses property: The resource status information.
     * 
     * @param statuses the statuses value to set.
     * @return the VirtualMachineExtensionInstanceView object itself.
     */
    public VirtualMachineExtensionInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (substatuses() != null) {
            substatuses().forEach(e -> e.validate());
        }
        if (statuses() != null) {
            statuses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("typeHandlerVersion", this.typeHandlerVersion);
        jsonWriter.writeArrayField("substatuses", this.substatuses, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineExtensionInstanceView from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineExtensionInstanceView if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineExtensionInstanceView.
     */
    public static VirtualMachineExtensionInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineExtensionInstanceView deserializedVirtualMachineExtensionInstanceView
                = new VirtualMachineExtensionInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineExtensionInstanceView.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVirtualMachineExtensionInstanceView.type = reader.getString();
                } else if ("typeHandlerVersion".equals(fieldName)) {
                    deserializedVirtualMachineExtensionInstanceView.typeHandlerVersion = reader.getString();
                } else if ("substatuses".equals(fieldName)) {
                    List<InstanceViewStatus> substatuses
                        = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedVirtualMachineExtensionInstanceView.substatuses = substatuses;
                } else if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses
                        = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedVirtualMachineExtensionInstanceView.statuses = statuses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineExtensionInstanceView;
        });
    }
}
