// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the uri of a disk.
 */
@Fluent
public final class VirtualHardDisk implements JsonSerializable<VirtualHardDisk> {
    /*
     * Specifies the virtual hard disk's uri.
     */
    private String uri;

    /**
     * Creates an instance of VirtualHardDisk class.
     */
    public VirtualHardDisk() {
    }

    /**
     * Get the uri property: Specifies the virtual hard disk's uri.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: Specifies the virtual hard disk's uri.
     * 
     * @param uri the uri value to set.
     * @return the VirtualHardDisk object itself.
     */
    public VirtualHardDisk withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualHardDisk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualHardDisk if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualHardDisk.
     */
    public static VirtualHardDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualHardDisk deserializedVirtualHardDisk = new VirtualHardDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uri".equals(fieldName)) {
                    deserializedVirtualHardDisk.uri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualHardDisk;
        });
    }
}
