// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes each OS upgrade on the Virtual Machine Scale Set.
 */
@Immutable
public final class UpgradeOperationHistoricalStatusInfoProperties
    implements JsonSerializable<UpgradeOperationHistoricalStatusInfoProperties> {
    /*
     * Information about the overall status of the upgrade operation.
     */
    private UpgradeOperationHistoryStatus runningStatus;

    /*
     * Counts of the VMs in each state.
     */
    private RollingUpgradeProgressInfo progress;

    /*
     * Error Details for this upgrade if there are any.
     */
    private ApiError error;

    /*
     * Invoker of the Upgrade Operation
     */
    private UpgradeOperationInvoker startedBy;

    /*
     * Image Reference details
     */
    private ImageReference targetImageReference;

    /*
     * Information about OS rollback if performed
     */
    private RollbackStatusInfo rollbackInfo;

    /**
     * Creates an instance of UpgradeOperationHistoricalStatusInfoProperties class.
     */
    public UpgradeOperationHistoricalStatusInfoProperties() {
    }

    /**
     * Get the runningStatus property: Information about the overall status of the upgrade operation.
     * 
     * @return the runningStatus value.
     */
    public UpgradeOperationHistoryStatus runningStatus() {
        return this.runningStatus;
    }

    /**
     * Get the progress property: Counts of the VMs in each state.
     * 
     * @return the progress value.
     */
    public RollingUpgradeProgressInfo progress() {
        return this.progress;
    }

    /**
     * Get the error property: Error Details for this upgrade if there are any.
     * 
     * @return the error value.
     */
    public ApiError error() {
        return this.error;
    }

    /**
     * Get the startedBy property: Invoker of the Upgrade Operation.
     * 
     * @return the startedBy value.
     */
    public UpgradeOperationInvoker startedBy() {
        return this.startedBy;
    }

    /**
     * Get the targetImageReference property: Image Reference details.
     * 
     * @return the targetImageReference value.
     */
    public ImageReference targetImageReference() {
        return this.targetImageReference;
    }

    /**
     * Get the rollbackInfo property: Information about OS rollback if performed.
     * 
     * @return the rollbackInfo value.
     */
    public RollbackStatusInfo rollbackInfo() {
        return this.rollbackInfo;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (runningStatus() != null) {
            runningStatus().validate();
        }
        if (progress() != null) {
            progress().validate();
        }
        if (error() != null) {
            error().validate();
        }
        if (targetImageReference() != null) {
            targetImageReference().validate();
        }
        if (rollbackInfo() != null) {
            rollbackInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpgradeOperationHistoricalStatusInfoProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpgradeOperationHistoricalStatusInfoProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpgradeOperationHistoricalStatusInfoProperties.
     */
    public static UpgradeOperationHistoricalStatusInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpgradeOperationHistoricalStatusInfoProperties deserializedUpgradeOperationHistoricalStatusInfoProperties
                = new UpgradeOperationHistoricalStatusInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("runningStatus".equals(fieldName)) {
                    deserializedUpgradeOperationHistoricalStatusInfoProperties.runningStatus
                        = UpgradeOperationHistoryStatus.fromJson(reader);
                } else if ("progress".equals(fieldName)) {
                    deserializedUpgradeOperationHistoricalStatusInfoProperties.progress
                        = RollingUpgradeProgressInfo.fromJson(reader);
                } else if ("error".equals(fieldName)) {
                    deserializedUpgradeOperationHistoricalStatusInfoProperties.error = ApiError.fromJson(reader);
                } else if ("startedBy".equals(fieldName)) {
                    deserializedUpgradeOperationHistoricalStatusInfoProperties.startedBy
                        = UpgradeOperationInvoker.fromString(reader.getString());
                } else if ("targetImageReference".equals(fieldName)) {
                    deserializedUpgradeOperationHistoricalStatusInfoProperties.targetImageReference
                        = ImageReference.fromJson(reader);
                } else if ("rollbackInfo".equals(fieldName)) {
                    deserializedUpgradeOperationHistoricalStatusInfoProperties.rollbackInfo
                        = RollbackStatusInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpgradeOperationHistoricalStatusInfoProperties;
        });
    }
}
