// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SubResourceWithColocationStatus model.
 */
@Fluent
public final class SubResourceWithColocationStatus extends SubResource {
    /*
     * Describes colocation status of a resource in the Proximity Placement Group.
     */
    private InstanceViewStatus colocationStatus;

    /**
     * Creates an instance of SubResourceWithColocationStatus class.
     */
    public SubResourceWithColocationStatus() {
    }

    /**
     * Get the colocationStatus property: Describes colocation status of a resource in the Proximity Placement Group.
     * 
     * @return the colocationStatus value.
     */
    public InstanceViewStatus colocationStatus() {
        return this.colocationStatus;
    }

    /**
     * Set the colocationStatus property: Describes colocation status of a resource in the Proximity Placement Group.
     * 
     * @param colocationStatus the colocationStatus value to set.
     * @return the SubResourceWithColocationStatus object itself.
     */
    public SubResourceWithColocationStatus withColocationStatus(InstanceViewStatus colocationStatus) {
        this.colocationStatus = colocationStatus;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SubResourceWithColocationStatus withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (colocationStatus() != null) {
            colocationStatus().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("colocationStatus", this.colocationStatus);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubResourceWithColocationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubResourceWithColocationStatus if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubResourceWithColocationStatus.
     */
    public static SubResourceWithColocationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubResourceWithColocationStatus deserializedSubResourceWithColocationStatus
                = new SubResourceWithColocationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSubResourceWithColocationStatus.withId(reader.getString());
                } else if ("colocationStatus".equals(fieldName)) {
                    deserializedSubResourceWithColocationStatus.colocationStatus = InstanceViewStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubResourceWithColocationStatus;
        });
    }
}
