// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SubResourceReadOnly model.
 */
@Immutable
public class SubResourceReadOnly implements JsonSerializable<SubResourceReadOnly> {
    /*
     * Resource Id
     */
    private String id;

    /**
     * Creates an instance of SubResourceReadOnly class.
     */
    public SubResourceReadOnly() {
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource Id.
     * 
     * @param id the id value to set.
     * @return the SubResourceReadOnly object itself.
     */
    SubResourceReadOnly withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubResourceReadOnly from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubResourceReadOnly if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubResourceReadOnly.
     */
    public static SubResourceReadOnly fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubResourceReadOnly deserializedSubResourceReadOnly = new SubResourceReadOnly();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSubResourceReadOnly.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubResourceReadOnly;
        });
    }
}
