// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Group of the gallery sharing profile.
 */
@Fluent
public final class SharingProfileGroup implements JsonSerializable<SharingProfileGroup> {
    /*
     * This property allows you to specify the type of sharing group. Possible values are: **Subscriptions,**
     * **AADTenants.**
     */
    private SharingProfileGroupTypes type;

    /*
     * A list of subscription/tenant ids the gallery is aimed to be shared to.
     */
    private List<String> ids;

    /**
     * Creates an instance of SharingProfileGroup class.
     */
    public SharingProfileGroup() {
    }

    /**
     * Get the type property: This property allows you to specify the type of sharing group. Possible values are:
     * **Subscriptions,** **AADTenants.**.
     * 
     * @return the type value.
     */
    public SharingProfileGroupTypes type() {
        return this.type;
    }

    /**
     * Set the type property: This property allows you to specify the type of sharing group. Possible values are:
     * **Subscriptions,** **AADTenants.**.
     * 
     * @param type the type value to set.
     * @return the SharingProfileGroup object itself.
     */
    public SharingProfileGroup withType(SharingProfileGroupTypes type) {
        this.type = type;
        return this;
    }

    /**
     * Get the ids property: A list of subscription/tenant ids the gallery is aimed to be shared to.
     * 
     * @return the ids value.
     */
    public List<String> ids() {
        return this.ids;
    }

    /**
     * Set the ids property: A list of subscription/tenant ids the gallery is aimed to be shared to.
     * 
     * @param ids the ids value to set.
     * @return the SharingProfileGroup object itself.
     */
    public SharingProfileGroup withIds(List<String> ids) {
        this.ids = ids;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("ids", this.ids, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharingProfileGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharingProfileGroup if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SharingProfileGroup.
     */
    public static SharingProfileGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharingProfileGroup deserializedSharingProfileGroup = new SharingProfileGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedSharingProfileGroup.type = SharingProfileGroupTypes.fromString(reader.getString());
                } else if ("ids".equals(fieldName)) {
                    List<String> ids = reader.readArray(reader1 -> reader1.getString());
                    deserializedSharingProfileGroup.ids = ids;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharingProfileGroup;
        });
    }
}
