// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Shared Galleries operation response.
 */
@Fluent
public final class SharedGalleryList implements JsonSerializable<SharedGalleryList> {
    /*
     * A list of shared galleries.
     */
    private List<SharedGalleryInner> value;

    /*
     * The uri to fetch the next page of shared galleries. Call ListNext() with this to fetch the next page of shared
     * galleries.
     */
    private String nextLink;

    /**
     * Creates an instance of SharedGalleryList class.
     */
    public SharedGalleryList() {
    }

    /**
     * Get the value property: A list of shared galleries.
     * 
     * @return the value value.
     */
    public List<SharedGalleryInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of shared galleries.
     * 
     * @param value the value value to set.
     * @return the SharedGalleryList object itself.
     */
    public SharedGalleryList withValue(List<SharedGalleryInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of shared galleries. Call ListNext() with this to fetch
     * the next page of shared galleries.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of shared galleries. Call ListNext() with this to fetch
     * the next page of shared galleries.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SharedGalleryList object itself.
     */
    public SharedGalleryList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model SharedGalleryList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SharedGalleryList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharedGalleryList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharedGalleryList if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SharedGalleryList.
     */
    public static SharedGalleryList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharedGalleryList deserializedSharedGalleryList = new SharedGalleryList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SharedGalleryInner> value = reader.readArray(reader1 -> SharedGalleryInner.fromJson(reader1));
                    deserializedSharedGalleryList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSharedGalleryList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharedGalleryList;
        });
    }
}
