// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes an Operating System disk.
 */
@Fluent
public final class RestorePointSourceVmosDisk implements JsonSerializable<RestorePointSourceVmosDisk> {
    /*
     * Gets the Operating System type.
     */
    private OperatingSystemType osType;

    /*
     * Gets the disk encryption settings.
     */
    private DiskEncryptionSettings encryptionSettings;

    /*
     * Gets the disk name.
     */
    private String name;

    /*
     * Gets the caching type.
     */
    private CachingTypes caching;

    /*
     * Gets the disk size in GB.
     */
    private Integer diskSizeGB;

    /*
     * Gets the managed disk details
     */
    private ManagedDiskParameters managedDisk;

    /*
     * Contains Disk Restore Point properties.
     */
    private DiskRestorePointAttributes diskRestorePoint;

    /*
     * Shows true if the disk is write-accelerator enabled.
     */
    private Boolean writeAcceleratorEnabled;

    /**
     * Creates an instance of RestorePointSourceVmosDisk class.
     */
    public RestorePointSourceVmosDisk() {
    }

    /**
     * Get the osType property: Gets the Operating System type.
     * 
     * @return the osType value.
     */
    public OperatingSystemType osType() {
        return this.osType;
    }

    /**
     * Get the encryptionSettings property: Gets the disk encryption settings.
     * 
     * @return the encryptionSettings value.
     */
    public DiskEncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    /**
     * Get the name property: Gets the disk name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the caching property: Gets the caching type.
     * 
     * @return the caching value.
     */
    public CachingTypes caching() {
        return this.caching;
    }

    /**
     * Get the diskSizeGB property: Gets the disk size in GB.
     * 
     * @return the diskSizeGB value.
     */
    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Get the managedDisk property: Gets the managed disk details.
     * 
     * @return the managedDisk value.
     */
    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    /**
     * Set the managedDisk property: Gets the managed disk details.
     * 
     * @param managedDisk the managedDisk value to set.
     * @return the RestorePointSourceVmosDisk object itself.
     */
    public RestorePointSourceVmosDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    /**
     * Get the diskRestorePoint property: Contains Disk Restore Point properties.
     * 
     * @return the diskRestorePoint value.
     */
    public DiskRestorePointAttributes diskRestorePoint() {
        return this.diskRestorePoint;
    }

    /**
     * Set the diskRestorePoint property: Contains Disk Restore Point properties.
     * 
     * @param diskRestorePoint the diskRestorePoint value to set.
     * @return the RestorePointSourceVmosDisk object itself.
     */
    public RestorePointSourceVmosDisk withDiskRestorePoint(DiskRestorePointAttributes diskRestorePoint) {
        this.diskRestorePoint = diskRestorePoint;
        return this;
    }

    /**
     * Get the writeAcceleratorEnabled property: Shows true if the disk is write-accelerator enabled.
     * 
     * @return the writeAcceleratorEnabled value.
     */
    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (encryptionSettings() != null) {
            encryptionSettings().validate();
        }
        if (managedDisk() != null) {
            managedDisk().validate();
        }
        if (diskRestorePoint() != null) {
            diskRestorePoint().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedDisk", this.managedDisk);
        jsonWriter.writeJsonField("diskRestorePoint", this.diskRestorePoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorePointSourceVmosDisk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorePointSourceVmosDisk if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorePointSourceVmosDisk.
     */
    public static RestorePointSourceVmosDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorePointSourceVmosDisk deserializedRestorePointSourceVmosDisk = new RestorePointSourceVmosDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("osType".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.osType = OperatingSystemType.fromString(reader.getString());
                } else if ("encryptionSettings".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.encryptionSettings = DiskEncryptionSettings.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.name = reader.getString();
                } else if ("caching".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.caching = CachingTypes.fromString(reader.getString());
                } else if ("diskSizeGB".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.diskSizeGB = reader.getNullable(JsonReader::getInt);
                } else if ("managedDisk".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.managedDisk = ManagedDiskParameters.fromJson(reader);
                } else if ("diskRestorePoint".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.diskRestorePoint
                        = DiskRestorePointAttributes.fromJson(reader);
                } else if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedRestorePointSourceVmosDisk.writeAcceleratorEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorePointSourceVmosDisk;
        });
    }
}
