// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the resource range.
 */
@Fluent
public final class ResourceRange implements JsonSerializable<ResourceRange> {
    /*
     * The minimum number of the resource.
     */
    private Integer min;

    /*
     * The maximum number of the resource.
     */
    private Integer max;

    /**
     * Creates an instance of ResourceRange class.
     */
    public ResourceRange() {
    }

    /**
     * Get the min property: The minimum number of the resource.
     * 
     * @return the min value.
     */
    public Integer min() {
        return this.min;
    }

    /**
     * Set the min property: The minimum number of the resource.
     * 
     * @param min the min value to set.
     * @return the ResourceRange object itself.
     */
    public ResourceRange withMin(Integer min) {
        this.min = min;
        return this;
    }

    /**
     * Get the max property: The maximum number of the resource.
     * 
     * @return the max value.
     */
    public Integer max() {
        return this.max;
    }

    /**
     * Set the max property: The maximum number of the resource.
     * 
     * @param max the max value to set.
     * @return the ResourceRange object itself.
     */
    public ResourceRange withMax(Integer max) {
        this.max = max;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("min", this.min);
        jsonWriter.writeNumberField("max", this.max);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceRange if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceRange.
     */
    public static ResourceRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceRange deserializedResourceRange = new ResourceRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("min".equals(fieldName)) {
                    deserializedResourceRange.min = reader.getNullable(JsonReader::getInt);
                } else if ("max".equals(fieldName)) {
                    deserializedResourceRange.max = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceRange;
        });
    }
}
