// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Instance view status.
 */
@Fluent
public final class ResourceInstanceViewStatus implements JsonSerializable<ResourceInstanceViewStatus> {
    /*
     * The status code.
     */
    private String code;

    /*
     * The short localizable label for the status.
     */
    private String displayStatus;

    /*
     * The detailed status message, including for alerts and error messages.
     */
    private String message;

    /*
     * The time of the status.
     */
    private OffsetDateTime time;

    /*
     * The level code.
     */
    private StatusLevelTypes level;

    /**
     * Creates an instance of ResourceInstanceViewStatus class.
     */
    public ResourceInstanceViewStatus() {
    }

    /**
     * Get the code property: The status code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the displayStatus property: The short localizable label for the status.
     * 
     * @return the displayStatus value.
     */
    public String displayStatus() {
        return this.displayStatus;
    }

    /**
     * Get the message property: The detailed status message, including for alerts and error messages.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the time property: The time of the status.
     * 
     * @return the time value.
     */
    public OffsetDateTime time() {
        return this.time;
    }

    /**
     * Get the level property: The level code.
     * 
     * @return the level value.
     */
    public StatusLevelTypes level() {
        return this.level;
    }

    /**
     * Set the level property: The level code.
     * 
     * @param level the level value to set.
     * @return the ResourceInstanceViewStatus object itself.
     */
    public ResourceInstanceViewStatus withLevel(StatusLevelTypes level) {
        this.level = level;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceInstanceViewStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceInstanceViewStatus if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceInstanceViewStatus.
     */
    public static ResourceInstanceViewStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceInstanceViewStatus deserializedResourceInstanceViewStatus = new ResourceInstanceViewStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedResourceInstanceViewStatus.code = reader.getString();
                } else if ("displayStatus".equals(fieldName)) {
                    deserializedResourceInstanceViewStatus.displayStatus = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedResourceInstanceViewStatus.message = reader.getString();
                } else if ("time".equals(fieldName)) {
                    deserializedResourceInstanceViewStatus.time = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("level".equals(fieldName)) {
                    deserializedResourceInstanceViewStatus.level = StatusLevelTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceInstanceViewStatus;
        });
    }
}
