// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the os disk image information.
 */
@Fluent
public final class OSDiskImage implements JsonSerializable<OSDiskImage> {
    /*
     * The operating system of the osDiskImage.
     */
    private OperatingSystemTypes operatingSystem;

    /**
     * Creates an instance of OSDiskImage class.
     */
    public OSDiskImage() {
    }

    /**
     * Get the operatingSystem property: The operating system of the osDiskImage.
     * 
     * @return the operatingSystem value.
     */
    public OperatingSystemTypes operatingSystem() {
        return this.operatingSystem;
    }

    /**
     * Set the operatingSystem property: The operating system of the osDiskImage.
     * 
     * @param operatingSystem the operatingSystem value to set.
     * @return the OSDiskImage object itself.
     */
    public OSDiskImage withOperatingSystem(OperatingSystemTypes operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operatingSystem() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property operatingSystem in model OSDiskImage"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OSDiskImage.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operatingSystem",
            this.operatingSystem == null ? null : this.operatingSystem.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OSDiskImage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OSDiskImage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OSDiskImage.
     */
    public static OSDiskImage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OSDiskImage deserializedOSDiskImage = new OSDiskImage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operatingSystem".equals(fieldName)) {
                    deserializedOSDiskImage.operatingSystem = OperatingSystemTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOSDiskImage;
        });
    }
}
