// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies the network interfaces or the networking configuration of the virtual machine.
 */
@Fluent
public final class NetworkProfile implements JsonSerializable<NetworkProfile> {
    /*
     * Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
     */
    private List<NetworkInterfaceReference> networkInterfaces;

    /*
     * specifies the Microsoft.Network API version used when creating networking resources in the Network Interface
     * Configurations
     */
    private NetworkApiVersion networkApiVersion;

    /*
     * Specifies the networking configurations that will be used to create the virtual machine networking resources.
     */
    private List<VirtualMachineNetworkInterfaceConfiguration> networkInterfaceConfigurations;

    /**
     * Creates an instance of NetworkProfile class.
     */
    public NetworkProfile() {
    }

    /**
     * Get the networkInterfaces property: Specifies the list of resource Ids for the network interfaces associated with
     * the virtual machine.
     * 
     * @return the networkInterfaces value.
     */
    public List<NetworkInterfaceReference> networkInterfaces() {
        return this.networkInterfaces;
    }

    /**
     * Set the networkInterfaces property: Specifies the list of resource Ids for the network interfaces associated with
     * the virtual machine.
     * 
     * @param networkInterfaces the networkInterfaces value to set.
     * @return the NetworkProfile object itself.
     */
    public NetworkProfile withNetworkInterfaces(List<NetworkInterfaceReference> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
        return this;
    }

    /**
     * Get the networkApiVersion property: specifies the Microsoft.Network API version used when creating networking
     * resources in the Network Interface Configurations.
     * 
     * @return the networkApiVersion value.
     */
    public NetworkApiVersion networkApiVersion() {
        return this.networkApiVersion;
    }

    /**
     * Set the networkApiVersion property: specifies the Microsoft.Network API version used when creating networking
     * resources in the Network Interface Configurations.
     * 
     * @param networkApiVersion the networkApiVersion value to set.
     * @return the NetworkProfile object itself.
     */
    public NetworkProfile withNetworkApiVersion(NetworkApiVersion networkApiVersion) {
        this.networkApiVersion = networkApiVersion;
        return this;
    }

    /**
     * Get the networkInterfaceConfigurations property: Specifies the networking configurations that will be used to
     * create the virtual machine networking resources.
     * 
     * @return the networkInterfaceConfigurations value.
     */
    public List<VirtualMachineNetworkInterfaceConfiguration> networkInterfaceConfigurations() {
        return this.networkInterfaceConfigurations;
    }

    /**
     * Set the networkInterfaceConfigurations property: Specifies the networking configurations that will be used to
     * create the virtual machine networking resources.
     * 
     * @param networkInterfaceConfigurations the networkInterfaceConfigurations value to set.
     * @return the NetworkProfile object itself.
     */
    public NetworkProfile withNetworkInterfaceConfigurations(
        List<VirtualMachineNetworkInterfaceConfiguration> networkInterfaceConfigurations) {
        this.networkInterfaceConfigurations = networkInterfaceConfigurations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkInterfaces() != null) {
            networkInterfaces().forEach(e -> e.validate());
        }
        if (networkInterfaceConfigurations() != null) {
            networkInterfaceConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("networkInterfaces", this.networkInterfaces,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("networkApiVersion",
            this.networkApiVersion == null ? null : this.networkApiVersion.toString());
        jsonWriter.writeArrayField("networkInterfaceConfigurations", this.networkInterfaceConfigurations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkProfile.
     */
    public static NetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkProfile deserializedNetworkProfile = new NetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkInterfaces".equals(fieldName)) {
                    List<NetworkInterfaceReference> networkInterfaces
                        = reader.readArray(reader1 -> NetworkInterfaceReference.fromJson(reader1));
                    deserializedNetworkProfile.networkInterfaces = networkInterfaces;
                } else if ("networkApiVersion".equals(fieldName)) {
                    deserializedNetworkProfile.networkApiVersion = NetworkApiVersion.fromString(reader.getString());
                } else if ("networkInterfaceConfigurations".equals(fieldName)) {
                    List<VirtualMachineNetworkInterfaceConfiguration> networkInterfaceConfigurations
                        = reader.readArray(reader1 -> VirtualMachineNetworkInterfaceConfiguration.fromJson(reader1));
                    deserializedNetworkProfile.networkInterfaceConfigurations = networkInterfaceConfigurations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkProfile;
        });
    }
}
