// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.ImageInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Image operation response.
 */
@Fluent
public final class ImageListResult implements JsonSerializable<ImageListResult> {
    /*
     * The list of Images.
     */
    private List<ImageInner> value;

    /*
     * The uri to fetch the next page of Images. Call ListNext() with this to fetch the next page of Images.
     */
    private String nextLink;

    /**
     * Creates an instance of ImageListResult class.
     */
    public ImageListResult() {
    }

    /**
     * Get the value property: The list of Images.
     * 
     * @return the value value.
     */
    public List<ImageInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of Images.
     * 
     * @param value the value value to set.
     * @return the ImageListResult object itself.
     */
    public ImageListResult withValue(List<ImageInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of Images. Call ListNext() with this to fetch the next
     * page of Images.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of Images. Call ListNext() with this to fetch the next
     * page of Images.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ImageListResult object itself.
     */
    public ImageListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model ImageListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImageListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImageListResult.
     */
    public static ImageListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageListResult deserializedImageListResult = new ImageListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ImageInner> value = reader.readArray(reader1 -> ImageInner.fromJson(reader1));
                    deserializedImageListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedImageListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImageListResult;
        });
    }
}
