// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The gallery artifact version source.
 */
@Fluent
public class GalleryArtifactVersionSource implements JsonSerializable<GalleryArtifactVersionSource> {
    /*
     * The id of the gallery artifact version source.
     */
    private String id;

    /**
     * Creates an instance of GalleryArtifactVersionSource class.
     */
    public GalleryArtifactVersionSource() {
    }

    /**
     * Get the id property: The id of the gallery artifact version source.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id of the gallery artifact version source.
     * 
     * @param id the id value to set.
     * @return the GalleryArtifactVersionSource object itself.
     */
    public GalleryArtifactVersionSource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryArtifactVersionSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryArtifactVersionSource if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryArtifactVersionSource.
     */
    public static GalleryArtifactVersionSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryArtifactVersionSource deserializedGalleryArtifactVersionSource = new GalleryArtifactVersionSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGalleryArtifactVersionSource.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryArtifactVersionSource;
        });
    }
}
