// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the dedicated host unutilized capacity in terms of a specific VM size.
 */
@Fluent
public final class DedicatedHostAllocatableVM implements JsonSerializable<DedicatedHostAllocatableVM> {
    /*
     * VM size in terms of which the unutilized capacity is represented.
     */
    private String vmSize;

    /*
     * Maximum number of VMs of size vmSize that can fit in the dedicated host's remaining capacity.
     */
    private Double count;

    /**
     * Creates an instance of DedicatedHostAllocatableVM class.
     */
    public DedicatedHostAllocatableVM() {
    }

    /**
     * Get the vmSize property: VM size in terms of which the unutilized capacity is represented.
     * 
     * @return the vmSize value.
     */
    public String vmSize() {
        return this.vmSize;
    }

    /**
     * Set the vmSize property: VM size in terms of which the unutilized capacity is represented.
     * 
     * @param vmSize the vmSize value to set.
     * @return the DedicatedHostAllocatableVM object itself.
     */
    public DedicatedHostAllocatableVM withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    /**
     * Get the count property: Maximum number of VMs of size vmSize that can fit in the dedicated host's remaining
     * capacity.
     * 
     * @return the count value.
     */
    public Double count() {
        return this.count;
    }

    /**
     * Set the count property: Maximum number of VMs of size vmSize that can fit in the dedicated host's remaining
     * capacity.
     * 
     * @param count the count value to set.
     * @return the DedicatedHostAllocatableVM object itself.
     */
    public DedicatedHostAllocatableVM withCount(Double count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DedicatedHostAllocatableVM from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DedicatedHostAllocatableVM if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DedicatedHostAllocatableVM.
     */
    public static DedicatedHostAllocatableVM fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostAllocatableVM deserializedDedicatedHostAllocatableVM = new DedicatedHostAllocatableVM();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vmSize".equals(fieldName)) {
                    deserializedDedicatedHostAllocatableVM.vmSize = reader.getString();
                } else if ("count".equals(fieldName)) {
                    deserializedDedicatedHostAllocatableVM.count = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDedicatedHostAllocatableVM;
        });
    }
}
