// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes the role profile for the cloud service.
 */
@Fluent
public final class CloudServiceRoleProfile implements JsonSerializable<CloudServiceRoleProfile> {
    /*
     * List of roles for the cloud service.
     */
    private List<CloudServiceRoleProfileProperties> roles;

    /**
     * Creates an instance of CloudServiceRoleProfile class.
     */
    public CloudServiceRoleProfile() {
    }

    /**
     * Get the roles property: List of roles for the cloud service.
     * 
     * @return the roles value.
     */
    public List<CloudServiceRoleProfileProperties> roles() {
        return this.roles;
    }

    /**
     * Set the roles property: List of roles for the cloud service.
     * 
     * @param roles the roles value to set.
     * @return the CloudServiceRoleProfile object itself.
     */
    public CloudServiceRoleProfile withRoles(List<CloudServiceRoleProfileProperties> roles) {
        this.roles = roles;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (roles() != null) {
            roles().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CloudServiceRoleProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CloudServiceRoleProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CloudServiceRoleProfile.
     */
    public static CloudServiceRoleProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudServiceRoleProfile deserializedCloudServiceRoleProfile = new CloudServiceRoleProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("roles".equals(fieldName)) {
                    List<CloudServiceRoleProfileProperties> roles
                        = reader.readArray(reader1 -> CloudServiceRoleProfileProperties.fromJson(reader1));
                    deserializedCloudServiceRoleProfile.roles = roles;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCloudServiceRoleProfile;
        });
    }
}
