// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The parameters of a capacity reservation Profile.
 */
@Fluent
public final class CapacityReservationProfile implements JsonSerializable<CapacityReservationProfile> {
    /*
     * Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or
     * scaleset vm instances provided enough capacity has been reserved. Please refer to
     * https://aka.ms/CapacityReservation for more details.
     */
    private SubResource capacityReservationGroup;

    /**
     * Creates an instance of CapacityReservationProfile class.
     */
    public CapacityReservationProfile() {
    }

    /**
     * Get the capacityReservationGroup property: Specifies the capacity reservation group resource id that should be
     * used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved.
     * Please refer to https://aka.ms/CapacityReservation for more details.
     * 
     * @return the capacityReservationGroup value.
     */
    public SubResource capacityReservationGroup() {
        return this.capacityReservationGroup;
    }

    /**
     * Set the capacityReservationGroup property: Specifies the capacity reservation group resource id that should be
     * used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved.
     * Please refer to https://aka.ms/CapacityReservation for more details.
     * 
     * @param capacityReservationGroup the capacityReservationGroup value to set.
     * @return the CapacityReservationProfile object itself.
     */
    public CapacityReservationProfile withCapacityReservationGroup(SubResource capacityReservationGroup) {
        this.capacityReservationGroup = capacityReservationGroup;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("capacityReservationGroup", this.capacityReservationGroup);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CapacityReservationProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CapacityReservationProfile if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CapacityReservationProfile.
     */
    public static CapacityReservationProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CapacityReservationProfile deserializedCapacityReservationProfile = new CapacityReservationProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("capacityReservationGroup".equals(fieldName)) {
                    deserializedCapacityReservationProfile.capacityReservationGroup = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapacityReservationProfile;
        });
    }
}
