// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the configuration parameters for automatic repairs on the virtual machine scale set.
 */
@Fluent
public final class AutomaticRepairsPolicy implements JsonSerializable<AutomaticRepairsPolicy> {
    /*
     * Specifies whether automatic repairs should be enabled on the virtual machine scale set. The default value is
     * false.
     */
    private Boolean enabled;

    /*
     * The amount of time for which automatic repairs are suspended due to a state change on VM. The grace time starts
     * after the state change has completed. This helps avoid premature or accidental repairs. The time duration should
     * be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes (PT10M), which is also the
     * default value. The maximum allowed grace period is 90 minutes (PT90M).
     */
    private String gracePeriod;

    /*
     * Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in
     * the scale set. Default value is replace.
     */
    private RepairAction repairAction;

    /**
     * Creates an instance of AutomaticRepairsPolicy class.
     */
    public AutomaticRepairsPolicy() {
    }

    /**
     * Get the enabled property: Specifies whether automatic repairs should be enabled on the virtual machine scale set.
     * The default value is false.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Specifies whether automatic repairs should be enabled on the virtual machine scale set.
     * The default value is false.
     * 
     * @param enabled the enabled value to set.
     * @return the AutomaticRepairsPolicy object itself.
     */
    public AutomaticRepairsPolicy withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the gracePeriod property: The amount of time for which automatic repairs are suspended due to a state change
     * on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental
     * repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes
     * (PT10M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
     * 
     * @return the gracePeriod value.
     */
    public String gracePeriod() {
        return this.gracePeriod;
    }

    /**
     * Set the gracePeriod property: The amount of time for which automatic repairs are suspended due to a state change
     * on VM. The grace time starts after the state change has completed. This helps avoid premature or accidental
     * repairs. The time duration should be specified in ISO 8601 format. The minimum allowed grace period is 10 minutes
     * (PT10M), which is also the default value. The maximum allowed grace period is 90 minutes (PT90M).
     * 
     * @param gracePeriod the gracePeriod value to set.
     * @return the AutomaticRepairsPolicy object itself.
     */
    public AutomaticRepairsPolicy withGracePeriod(String gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    /**
     * Get the repairAction property: Type of repair action (replace, restart, reimage) that will be used for repairing
     * unhealthy virtual machines in the scale set. Default value is replace.
     * 
     * @return the repairAction value.
     */
    public RepairAction repairAction() {
        return this.repairAction;
    }

    /**
     * Set the repairAction property: Type of repair action (replace, restart, reimage) that will be used for repairing
     * unhealthy virtual machines in the scale set. Default value is replace.
     * 
     * @param repairAction the repairAction value to set.
     * @return the AutomaticRepairsPolicy object itself.
     */
    public AutomaticRepairsPolicy withRepairAction(RepairAction repairAction) {
        this.repairAction = repairAction;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("gracePeriod", this.gracePeriod);
        jsonWriter.writeStringField("repairAction", this.repairAction == null ? null : this.repairAction.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutomaticRepairsPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutomaticRepairsPolicy if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AutomaticRepairsPolicy.
     */
    public static AutomaticRepairsPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutomaticRepairsPolicy deserializedAutomaticRepairsPolicy = new AutomaticRepairsPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedAutomaticRepairsPolicy.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("gracePeriod".equals(fieldName)) {
                    deserializedAutomaticRepairsPolicy.gracePeriod = reader.getString();
                } else if ("repairAction".equals(fieldName)) {
                    deserializedAutomaticRepairsPolicy.repairAction = RepairAction.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutomaticRepairsPolicy;
        });
    }
}
