// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The List VMSS VM Extension operation response.
 */
@Fluent
public final class VirtualMachineScaleSetVMExtensionsListResultInner
    implements JsonSerializable<VirtualMachineScaleSetVMExtensionsListResultInner> {
    /*
     * The list of VMSS VM extensions
     */
    private List<VirtualMachineScaleSetVMExtensionInner> value;

    /**
     * Creates an instance of VirtualMachineScaleSetVMExtensionsListResultInner class.
     */
    public VirtualMachineScaleSetVMExtensionsListResultInner() {
    }

    /**
     * Get the value property: The list of VMSS VM extensions.
     * 
     * @return the value value.
     */
    public List<VirtualMachineScaleSetVMExtensionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of VMSS VM extensions.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineScaleSetVMExtensionsListResultInner object itself.
     */
    public VirtualMachineScaleSetVMExtensionsListResultInner
        withValue(List<VirtualMachineScaleSetVMExtensionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetVMExtensionsListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetVMExtensionsListResultInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetVMExtensionsListResultInner.
     */
    public static VirtualMachineScaleSetVMExtensionsListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMExtensionsListResultInner deserializedVirtualMachineScaleSetVMExtensionsListResultInner
                = new VirtualMachineScaleSetVMExtensionsListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualMachineScaleSetVMExtensionInner> value
                        = reader.readArray(reader1 -> VirtualMachineScaleSetVMExtensionInner.fromJson(reader1));
                    deserializedVirtualMachineScaleSetVMExtensionsListResultInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetVMExtensionsListResultInner;
        });
    }
}
