// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.RoleInstanceNetworkProfile;
import java.io.IOException;

/**
 * Role instance properties.
 */
@Fluent
public final class RoleInstancePropertiesInner implements JsonSerializable<RoleInstancePropertiesInner> {
    /*
     * Describes the network profile for the role instance.
     */
    private RoleInstanceNetworkProfile networkProfile;

    /*
     * The instance view of the role instance.
     */
    private RoleInstanceViewInner instanceView;

    /**
     * Creates an instance of RoleInstancePropertiesInner class.
     */
    public RoleInstancePropertiesInner() {
    }

    /**
     * Get the networkProfile property: Describes the network profile for the role instance.
     * 
     * @return the networkProfile value.
     */
    public RoleInstanceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: Describes the network profile for the role instance.
     * 
     * @param networkProfile the networkProfile value to set.
     * @return the RoleInstancePropertiesInner object itself.
     */
    public RoleInstancePropertiesInner withNetworkProfile(RoleInstanceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the instanceView property: The instance view of the role instance.
     * 
     * @return the instanceView value.
     */
    public RoleInstanceViewInner instanceView() {
        return this.instanceView;
    }

    /**
     * Set the instanceView property: The instance view of the role instance.
     * 
     * @param instanceView the instanceView value to set.
     * @return the RoleInstancePropertiesInner object itself.
     */
    public RoleInstancePropertiesInner withInstanceView(RoleInstanceViewInner instanceView) {
        this.instanceView = instanceView;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkProfile() != null) {
            networkProfile().validate();
        }
        if (instanceView() != null) {
            instanceView().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkProfile", this.networkProfile);
        jsonWriter.writeJsonField("instanceView", this.instanceView);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleInstancePropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleInstancePropertiesInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleInstancePropertiesInner.
     */
    public static RoleInstancePropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleInstancePropertiesInner deserializedRoleInstancePropertiesInner = new RoleInstancePropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkProfile".equals(fieldName)) {
                    deserializedRoleInstancePropertiesInner.networkProfile
                        = RoleInstanceNetworkProfile.fromJson(reader);
                } else if ("instanceView".equals(fieldName)) {
                    deserializedRoleInstancePropertiesInner.instanceView = RoleInstanceViewInner.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleInstancePropertiesInner;
        });
    }
}
