// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SAS URIs of the console screenshot and serial log blobs.
 */
@Immutable
public final class RetrieveBootDiagnosticsDataResultInner
    implements JsonSerializable<RetrieveBootDiagnosticsDataResultInner> {
    /*
     * The console screenshot blob URI
     */
    private String consoleScreenshotBlobUri;

    /*
     * The serial console log blob URI.
     */
    private String serialConsoleLogBlobUri;

    /**
     * Creates an instance of RetrieveBootDiagnosticsDataResultInner class.
     */
    public RetrieveBootDiagnosticsDataResultInner() {
    }

    /**
     * Get the consoleScreenshotBlobUri property: The console screenshot blob URI.
     * 
     * @return the consoleScreenshotBlobUri value.
     */
    public String consoleScreenshotBlobUri() {
        return this.consoleScreenshotBlobUri;
    }

    /**
     * Get the serialConsoleLogBlobUri property: The serial console log blob URI.
     * 
     * @return the serialConsoleLogBlobUri value.
     */
    public String serialConsoleLogBlobUri() {
        return this.serialConsoleLogBlobUri;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RetrieveBootDiagnosticsDataResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RetrieveBootDiagnosticsDataResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RetrieveBootDiagnosticsDataResultInner.
     */
    public static RetrieveBootDiagnosticsDataResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RetrieveBootDiagnosticsDataResultInner deserializedRetrieveBootDiagnosticsDataResultInner
                = new RetrieveBootDiagnosticsDataResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("consoleScreenshotBlobUri".equals(fieldName)) {
                    deserializedRetrieveBootDiagnosticsDataResultInner.consoleScreenshotBlobUri = reader.getString();
                } else if ("serialConsoleLogBlobUri".equals(fieldName)) {
                    deserializedRetrieveBootDiagnosticsDataResultInner.serialConsoleLogBlobUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRetrieveBootDiagnosticsDataResultInner;
        });
    }
}
