// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties of an incremental disk restore point.
 */
@Fluent
public final class DiskRestorePointProperties implements JsonSerializable<DiskRestorePointProperties> {
    /*
     * The timestamp of restorePoint creation
     */
    private OffsetDateTime timeCreated;

    /*
     * arm id of source disk or source disk restore point.
     */
    private String sourceResourceId;

    /*
     * The Operating System type.
     */
    private OperatingSystemTypes osType;

    /*
     * The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    private HyperVGeneration hyperVGeneration;

    /*
     * Purchase plan information for the the image from which the OS disk was created.
     */
    private PurchasePlanAutoGenerated purchasePlan;

    /*
     * List of supported capabilities for the image from which the OS disk was created.
     */
    private SupportedCapabilities supportedCapabilities;

    /*
     * id of the backing snapshot's MIS family
     */
    private String familyId;

    /*
     * unique incarnation id of the source disk
     */
    private String sourceUniqueId;

    /*
     * Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    private Encryption encryption;

    /*
     * Indicates the OS on a disk supports hibernation.
     */
    private Boolean supportsHibernation;

    /*
     * Policy for accessing the disk via network.
     */
    private NetworkAccessPolicy networkAccessPolicy;

    /*
     * Policy for controlling export on the disk.
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    private String diskAccessId;

    /*
     * Percentage complete for the background copy of disk restore point when source resource is from a different
     * region.
     */
    private Float completionPercent;

    /*
     * Replication state of disk restore point when source resource is from a different region.
     */
    private String replicationState;

    /*
     * Location of source disk or source disk restore point when source resource is from a different region.
     */
    private String sourceResourceLocation;

    /*
     * Contains the security related information for the resource.
     */
    private DiskSecurityProfile securityProfile;

    /*
     * Logical sector size in bytes for disk restore points of UltraSSD_LRS and PremiumV2_LRS disks. Supported values
     * are 512 and 4096. 4096 is the default.
     */
    private Integer logicalSectorSize;

    /**
     * Creates an instance of DiskRestorePointProperties class.
     */
    public DiskRestorePointProperties() {
    }

    /**
     * Get the timeCreated property: The timestamp of restorePoint creation.
     * 
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    /**
     * Get the sourceResourceId property: arm id of source disk or source disk restore point.
     * 
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    /**
     * Get the osType property: The Operating System type.
     * 
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Get the hyperVGeneration property: The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     * 
     * @return the hyperVGeneration value.
     */
    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    /**
     * Set the hyperVGeneration property: The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     * 
     * @param hyperVGeneration the hyperVGeneration value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    /**
     * Get the purchasePlan property: Purchase plan information for the the image from which the OS disk was created.
     * 
     * @return the purchasePlan value.
     */
    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    /**
     * Set the purchasePlan property: Purchase plan information for the the image from which the OS disk was created.
     * 
     * @param purchasePlan the purchasePlan value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    /**
     * Get the supportedCapabilities property: List of supported capabilities for the image from which the OS disk was
     * created.
     * 
     * @return the supportedCapabilities value.
     */
    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    /**
     * Set the supportedCapabilities property: List of supported capabilities for the image from which the OS disk was
     * created.
     * 
     * @param supportedCapabilities the supportedCapabilities value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    /**
     * Get the familyId property: id of the backing snapshot's MIS family.
     * 
     * @return the familyId value.
     */
    public String familyId() {
        return this.familyId;
    }

    /**
     * Get the sourceUniqueId property: unique incarnation id of the source disk.
     * 
     * @return the sourceUniqueId value.
     */
    public String sourceUniqueId() {
        return this.sourceUniqueId;
    }

    /**
     * Get the encryption property: Encryption property can be used to encrypt data at rest with customer managed keys
     * or platform managed keys.
     * 
     * @return the encryption value.
     */
    public Encryption encryption() {
        return this.encryption;
    }

    /**
     * Get the supportsHibernation property: Indicates the OS on a disk supports hibernation.
     * 
     * @return the supportsHibernation value.
     */
    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    /**
     * Set the supportsHibernation property: Indicates the OS on a disk supports hibernation.
     * 
     * @param supportsHibernation the supportsHibernation value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    /**
     * Get the networkAccessPolicy property: Policy for accessing the disk via network.
     * 
     * @return the networkAccessPolicy value.
     */
    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    /**
     * Set the networkAccessPolicy property: Policy for accessing the disk via network.
     * 
     * @param networkAccessPolicy the networkAccessPolicy value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Policy for controlling export on the disk.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Policy for controlling export on the disk.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the diskAccessId property: ARM id of the DiskAccess resource for using private endpoints on disks.
     * 
     * @return the diskAccessId value.
     */
    public String diskAccessId() {
        return this.diskAccessId;
    }

    /**
     * Set the diskAccessId property: ARM id of the DiskAccess resource for using private endpoints on disks.
     * 
     * @param diskAccessId the diskAccessId value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    /**
     * Get the completionPercent property: Percentage complete for the background copy of disk restore point when source
     * resource is from a different region.
     * 
     * @return the completionPercent value.
     */
    public Float completionPercent() {
        return this.completionPercent;
    }

    /**
     * Set the completionPercent property: Percentage complete for the background copy of disk restore point when source
     * resource is from a different region.
     * 
     * @param completionPercent the completionPercent value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withCompletionPercent(Float completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    /**
     * Get the replicationState property: Replication state of disk restore point when source resource is from a
     * different region.
     * 
     * @return the replicationState value.
     */
    public String replicationState() {
        return this.replicationState;
    }

    /**
     * Get the sourceResourceLocation property: Location of source disk or source disk restore point when source
     * resource is from a different region.
     * 
     * @return the sourceResourceLocation value.
     */
    public String sourceResourceLocation() {
        return this.sourceResourceLocation;
    }

    /**
     * Get the securityProfile property: Contains the security related information for the resource.
     * 
     * @return the securityProfile value.
     */
    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    /**
     * Set the securityProfile property: Contains the security related information for the resource.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the DiskRestorePointProperties object itself.
     */
    public DiskRestorePointProperties withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    /**
     * Get the logicalSectorSize property: Logical sector size in bytes for disk restore points of UltraSSD_LRS and
     * PremiumV2_LRS disks. Supported values are 512 and 4096. 4096 is the default.
     * 
     * @return the logicalSectorSize value.
     */
    public Integer logicalSectorSize() {
        return this.logicalSectorSize;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (purchasePlan() != null) {
            purchasePlan().validate();
        }
        if (supportedCapabilities() != null) {
            supportedCapabilities().validate();
        }
        if (encryption() != null) {
            encryption().validate();
        }
        if (securityProfile() != null) {
            securityProfile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hyperVGeneration",
            this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeJsonField("purchasePlan", this.purchasePlan);
        jsonWriter.writeJsonField("supportedCapabilities", this.supportedCapabilities);
        jsonWriter.writeBooleanField("supportsHibernation", this.supportsHibernation);
        jsonWriter.writeStringField("networkAccessPolicy",
            this.networkAccessPolicy == null ? null : this.networkAccessPolicy.toString());
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("diskAccessId", this.diskAccessId);
        jsonWriter.writeNumberField("completionPercent", this.completionPercent);
        jsonWriter.writeJsonField("securityProfile", this.securityProfile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskRestorePointProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskRestorePointProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskRestorePointProperties.
     */
    public static DiskRestorePointProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskRestorePointProperties deserializedDiskRestorePointProperties = new DiskRestorePointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeCreated".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.timeCreated = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("sourceResourceId".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.sourceResourceId = reader.getString();
                } else if ("osType".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                } else if ("hyperVGeneration".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.hyperVGeneration
                        = HyperVGeneration.fromString(reader.getString());
                } else if ("purchasePlan".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.purchasePlan = PurchasePlanAutoGenerated.fromJson(reader);
                } else if ("supportedCapabilities".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.supportedCapabilities
                        = SupportedCapabilities.fromJson(reader);
                } else if ("familyId".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.familyId = reader.getString();
                } else if ("sourceUniqueId".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.sourceUniqueId = reader.getString();
                } else if ("encryption".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.encryption = Encryption.fromJson(reader);
                } else if ("supportsHibernation".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.supportsHibernation
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("networkAccessPolicy".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.networkAccessPolicy
                        = NetworkAccessPolicy.fromString(reader.getString());
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("diskAccessId".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.diskAccessId = reader.getString();
                } else if ("completionPercent".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.completionPercent = reader.getNullable(JsonReader::getFloat);
                } else if ("replicationState".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.replicationState = reader.getString();
                } else if ("sourceResourceLocation".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.sourceResourceLocation = reader.getString();
                } else if ("securityProfile".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.securityProfile = DiskSecurityProfile.fromJson(reader);
                } else if ("logicalSectorSize".equals(fieldName)) {
                    deserializedDiskRestorePointProperties.logicalSectorSize = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskRestorePointProperties;
        });
    }
}
