// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CloudServiceProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Describes the cloud service.
 */
@Fluent
public final class CloudServiceInner extends Resource {
    /*
     * Cloud service properties
     */
    private CloudServiceProperties properties;

    /*
     * The system meta data relating to this resource.
     */
    private SystemData systemData;

    /*
     * List of logical availability zone of the resource. List should contain only 1 zone where cloud service should be
     * provisioned. This field is optional.
     */
    private List<String> zones;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of CloudServiceInner class.
     */
    public CloudServiceInner() {
    }

    /**
     * Get the properties property: Cloud service properties.
     * 
     * @return the properties value.
     */
    public CloudServiceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Cloud service properties.
     * 
     * @param properties the properties value to set.
     * @return the CloudServiceInner object itself.
     */
    public CloudServiceInner withProperties(CloudServiceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Set the systemData property: The system meta data relating to this resource.
     * 
     * @param systemData the systemData value to set.
     * @return the CloudServiceInner object itself.
     */
    public CloudServiceInner withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    /**
     * Get the zones property: List of logical availability zone of the resource. List should contain only 1 zone where
     * cloud service should be provisioned. This field is optional.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Set the zones property: List of logical availability zone of the resource. List should contain only 1 zone where
     * cloud service should be provisioned. This field is optional.
     * 
     * @param zones the zones value to set.
     * @return the CloudServiceInner object itself.
     */
    public CloudServiceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CloudServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CloudServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeJsonField("systemData", this.systemData);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CloudServiceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CloudServiceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CloudServiceInner.
     */
    public static CloudServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudServiceInner deserializedCloudServiceInner = new CloudServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCloudServiceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedCloudServiceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCloudServiceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedCloudServiceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCloudServiceInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedCloudServiceInner.properties = CloudServiceProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedCloudServiceInner.systemData = SystemData.fromJson(reader);
                } else if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedCloudServiceInner.zones = zones;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCloudServiceInner;
        });
    }
}
