/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.LogAnalyticsInputBase;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ThrottledRequestsInput
extends LogAnalyticsInputBase {
    @Override
    public ThrottledRequestsInput withBlobContainerSasUri(String blobContainerSasUri) {
        super.withBlobContainerSasUri(blobContainerSasUri);
        return this;
    }

    @Override
    public ThrottledRequestsInput withFromTime(OffsetDateTime fromTime) {
        super.withFromTime(fromTime);
        return this;
    }

    @Override
    public ThrottledRequestsInput withToTime(OffsetDateTime toTime) {
        super.withToTime(toTime);
        return this;
    }

    @Override
    public ThrottledRequestsInput withGroupByThrottlePolicy(Boolean groupByThrottlePolicy) {
        super.withGroupByThrottlePolicy(groupByThrottlePolicy);
        return this;
    }

    @Override
    public ThrottledRequestsInput withGroupByOperationName(Boolean groupByOperationName) {
        super.withGroupByOperationName(groupByOperationName);
        return this;
    }

    @Override
    public ThrottledRequestsInput withGroupByResourceName(Boolean groupByResourceName) {
        super.withGroupByResourceName(groupByResourceName);
        return this;
    }

    @Override
    public ThrottledRequestsInput withGroupByClientApplicationId(Boolean groupByClientApplicationId) {
        super.withGroupByClientApplicationId(groupByClientApplicationId);
        return this;
    }

    @Override
    public ThrottledRequestsInput withGroupByUserAgent(Boolean groupByUserAgent) {
        super.withGroupByUserAgent(groupByUserAgent);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("blobContainerSasUri", this.blobContainerSasUri());
        jsonWriter.writeStringField("fromTime", this.fromTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.fromTime()));
        jsonWriter.writeStringField("toTime", this.toTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.toTime()));
        jsonWriter.writeBooleanField("groupByThrottlePolicy", this.groupByThrottlePolicy());
        jsonWriter.writeBooleanField("groupByOperationName", this.groupByOperationName());
        jsonWriter.writeBooleanField("groupByResourceName", this.groupByResourceName());
        jsonWriter.writeBooleanField("groupByClientApplicationId", this.groupByClientApplicationId());
        jsonWriter.writeBooleanField("groupByUserAgent", this.groupByUserAgent());
        return jsonWriter.writeEndObject();
    }

    public static ThrottledRequestsInput fromJson(JsonReader jsonReader) throws IOException {
        return (ThrottledRequestsInput)jsonReader.readObject(reader -> {
            ThrottledRequestsInput deserializedThrottledRequestsInput = new ThrottledRequestsInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blobContainerSasUri".equals(fieldName)) {
                    deserializedThrottledRequestsInput.withBlobContainerSasUri(reader.getString());
                    continue;
                }
                if ("fromTime".equals(fieldName)) {
                    deserializedThrottledRequestsInput.withFromTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("toTime".equals(fieldName)) {
                    deserializedThrottledRequestsInput.withToTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("groupByThrottlePolicy".equals(fieldName)) {
                    deserializedThrottledRequestsInput.withGroupByThrottlePolicy((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("groupByOperationName".equals(fieldName)) {
                    deserializedThrottledRequestsInput.withGroupByOperationName((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("groupByResourceName".equals(fieldName)) {
                    deserializedThrottledRequestsInput.withGroupByResourceName((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("groupByClientApplicationId".equals(fieldName)) {
                    deserializedThrottledRequestsInput.withGroupByClientApplicationId((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("groupByUserAgent".equals(fieldName)) {
                    deserializedThrottledRequestsInput.withGroupByUserAgent((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThrottledRequestsInput;
        });
    }
}

