/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import java.io.IOException;

public final class DiskRestorePointReplicationStatus
implements JsonSerializable<DiskRestorePointReplicationStatus> {
    private InstanceViewStatus status;
    private Integer completionPercent;

    public InstanceViewStatus status() {
        return this.status;
    }

    public DiskRestorePointReplicationStatus withStatus(InstanceViewStatus status) {
        this.status = status;
        return this;
    }

    public Integer completionPercent() {
        return this.completionPercent;
    }

    public DiskRestorePointReplicationStatus withCompletionPercent(Integer completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    public void validate() {
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("status", (JsonSerializable)this.status);
        jsonWriter.writeNumberField("completionPercent", (Number)this.completionPercent);
        return jsonWriter.writeEndObject();
    }

    public static DiskRestorePointReplicationStatus fromJson(JsonReader jsonReader) throws IOException {
        return (DiskRestorePointReplicationStatus)jsonReader.readObject(reader -> {
            DiskRestorePointReplicationStatus deserializedDiskRestorePointReplicationStatus = new DiskRestorePointReplicationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedDiskRestorePointReplicationStatus.status = InstanceViewStatus.fromJson(reader);
                    continue;
                }
                if ("completionPercent".equals(fieldName)) {
                    deserializedDiskRestorePointReplicationStatus.completionPercent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskRestorePointReplicationStatus;
        });
    }
}

