/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiError;
import com.azure.resourcemanager.compute.models.PatchOperationStatus;
import com.azure.resourcemanager.compute.models.VirtualMachineSoftwarePatchProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class VirtualMachineAssessPatchesResultInner
implements JsonSerializable<VirtualMachineAssessPatchesResultInner> {
    private PatchOperationStatus status;
    private String assessmentActivityId;
    private Boolean rebootPending;
    private Integer criticalAndSecurityPatchCount;
    private Integer otherPatchCount;
    private OffsetDateTime startDateTime;
    private List<VirtualMachineSoftwarePatchProperties> availablePatches;
    private ApiError error;

    public PatchOperationStatus status() {
        return this.status;
    }

    public String assessmentActivityId() {
        return this.assessmentActivityId;
    }

    public Boolean rebootPending() {
        return this.rebootPending;
    }

    public Integer criticalAndSecurityPatchCount() {
        return this.criticalAndSecurityPatchCount;
    }

    public Integer otherPatchCount() {
        return this.otherPatchCount;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public List<VirtualMachineSoftwarePatchProperties> availablePatches() {
        return this.availablePatches;
    }

    public ApiError error() {
        return this.error;
    }

    public void validate() {
        if (this.availablePatches() != null) {
            this.availablePatches().forEach(e -> e.validate());
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineAssessPatchesResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineAssessPatchesResultInner)jsonReader.readObject(reader -> {
            VirtualMachineAssessPatchesResultInner deserializedVirtualMachineAssessPatchesResultInner = new VirtualMachineAssessPatchesResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedVirtualMachineAssessPatchesResultInner.status = PatchOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("assessmentActivityId".equals(fieldName)) {
                    deserializedVirtualMachineAssessPatchesResultInner.assessmentActivityId = reader.getString();
                    continue;
                }
                if ("rebootPending".equals(fieldName)) {
                    deserializedVirtualMachineAssessPatchesResultInner.rebootPending = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("criticalAndSecurityPatchCount".equals(fieldName)) {
                    deserializedVirtualMachineAssessPatchesResultInner.criticalAndSecurityPatchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("otherPatchCount".equals(fieldName)) {
                    deserializedVirtualMachineAssessPatchesResultInner.otherPatchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedVirtualMachineAssessPatchesResultInner.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("availablePatches".equals(fieldName)) {
                    List availablePatches;
                    deserializedVirtualMachineAssessPatchesResultInner.availablePatches = availablePatches = reader.readArray(reader1 -> VirtualMachineSoftwarePatchProperties.fromJson(reader1));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedVirtualMachineAssessPatchesResultInner.error = ApiError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineAssessPatchesResultInner;
        });
    }
}

