// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a virtual machines network configuration's DNS settings.
 */
@Fluent
public final class VirtualMachinePublicIpAddressDnsSettingsConfiguration
    implements JsonSerializable<VirtualMachinePublicIpAddressDnsSettingsConfiguration> {
    /*
     * The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is
     * the concatenation of the domain name label and vm network profile unique ID.
     */
    private String domainNameLabel;

    /*
     * The Domain name label scope of the PublicIPAddress resources that will be created. The generated name label is
     * the concatenation of the hashed domain name label with policy according to the domain name label scope and vm
     * network profile unique ID.
     */
    private DomainNameLabelScopeTypes domainNameLabelScope;

    /**
     * Creates an instance of VirtualMachinePublicIpAddressDnsSettingsConfiguration class.
     */
    public VirtualMachinePublicIpAddressDnsSettingsConfiguration() {
    }

    /**
     * Get the domainNameLabel property: The Domain name label prefix of the PublicIPAddress resources that will be
     * created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
     * 
     * @return the domainNameLabel value.
     */
    public String domainNameLabel() {
        return this.domainNameLabel;
    }

    /**
     * Set the domainNameLabel property: The Domain name label prefix of the PublicIPAddress resources that will be
     * created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.
     * 
     * @param domainNameLabel the domainNameLabel value to set.
     * @return the VirtualMachinePublicIpAddressDnsSettingsConfiguration object itself.
     */
    public VirtualMachinePublicIpAddressDnsSettingsConfiguration withDomainNameLabel(String domainNameLabel) {
        this.domainNameLabel = domainNameLabel;
        return this;
    }

    /**
     * Get the domainNameLabelScope property: The Domain name label scope of the PublicIPAddress resources that will be
     * created. The generated name label is the concatenation of the hashed domain name label with policy according to
     * the domain name label scope and vm network profile unique ID.
     * 
     * @return the domainNameLabelScope value.
     */
    public DomainNameLabelScopeTypes domainNameLabelScope() {
        return this.domainNameLabelScope;
    }

    /**
     * Set the domainNameLabelScope property: The Domain name label scope of the PublicIPAddress resources that will be
     * created. The generated name label is the concatenation of the hashed domain name label with policy according to
     * the domain name label scope and vm network profile unique ID.
     * 
     * @param domainNameLabelScope the domainNameLabelScope value to set.
     * @return the VirtualMachinePublicIpAddressDnsSettingsConfiguration object itself.
     */
    public VirtualMachinePublicIpAddressDnsSettingsConfiguration
        withDomainNameLabelScope(DomainNameLabelScopeTypes domainNameLabelScope) {
        this.domainNameLabelScope = domainNameLabelScope;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (domainNameLabel() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property domainNameLabel in model VirtualMachinePublicIpAddressDnsSettingsConfiguration"));
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(VirtualMachinePublicIpAddressDnsSettingsConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("domainNameLabel", this.domainNameLabel);
        jsonWriter.writeStringField("domainNameLabelScope",
            this.domainNameLabelScope == null ? null : this.domainNameLabelScope.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachinePublicIpAddressDnsSettingsConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachinePublicIpAddressDnsSettingsConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachinePublicIpAddressDnsSettingsConfiguration.
     */
    public static VirtualMachinePublicIpAddressDnsSettingsConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachinePublicIpAddressDnsSettingsConfiguration deserializedVirtualMachinePublicIpAddressDnsSettingsConfiguration
                = new VirtualMachinePublicIpAddressDnsSettingsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("domainNameLabel".equals(fieldName)) {
                    deserializedVirtualMachinePublicIpAddressDnsSettingsConfiguration.domainNameLabel
                        = reader.getString();
                } else if ("domainNameLabelScope".equals(fieldName)) {
                    deserializedVirtualMachinePublicIpAddressDnsSettingsConfiguration.domainNameLabelScope
                        = DomainNameLabelScopeTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachinePublicIpAddressDnsSettingsConfiguration;
        });
    }
}
