// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Api request input for LogAnalytics getRequestRateByInterval Api.
 */
@Fluent
public final class RequestRateByIntervalInput extends LogAnalyticsInputBase {
    /*
     * Interval value in minutes used to create LogAnalytics call rate logs.
     */
    private IntervalInMins intervalLength;

    /**
     * Creates an instance of RequestRateByIntervalInput class.
     */
    public RequestRateByIntervalInput() {
    }

    /**
     * Get the intervalLength property: Interval value in minutes used to create LogAnalytics call rate logs.
     * 
     * @return the intervalLength value.
     */
    public IntervalInMins intervalLength() {
        return this.intervalLength;
    }

    /**
     * Set the intervalLength property: Interval value in minutes used to create LogAnalytics call rate logs.
     * 
     * @param intervalLength the intervalLength value to set.
     * @return the RequestRateByIntervalInput object itself.
     */
    public RequestRateByIntervalInput withIntervalLength(IntervalInMins intervalLength) {
        this.intervalLength = intervalLength;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestRateByIntervalInput withBlobContainerSasUri(String blobContainerSasUri) {
        super.withBlobContainerSasUri(blobContainerSasUri);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestRateByIntervalInput withFromTime(OffsetDateTime fromTime) {
        super.withFromTime(fromTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestRateByIntervalInput withToTime(OffsetDateTime toTime) {
        super.withToTime(toTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestRateByIntervalInput withGroupByThrottlePolicy(Boolean groupByThrottlePolicy) {
        super.withGroupByThrottlePolicy(groupByThrottlePolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestRateByIntervalInput withGroupByOperationName(Boolean groupByOperationName) {
        super.withGroupByOperationName(groupByOperationName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestRateByIntervalInput withGroupByResourceName(Boolean groupByResourceName) {
        super.withGroupByResourceName(groupByResourceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestRateByIntervalInput withGroupByClientApplicationId(Boolean groupByClientApplicationId) {
        super.withGroupByClientApplicationId(groupByClientApplicationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RequestRateByIntervalInput withGroupByUserAgent(Boolean groupByUserAgent) {
        super.withGroupByUserAgent(groupByUserAgent);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (intervalLength() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property intervalLength in model RequestRateByIntervalInput"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RequestRateByIntervalInput.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("blobContainerSasUri", blobContainerSasUri());
        jsonWriter.writeStringField("fromTime",
            fromTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(fromTime()));
        jsonWriter.writeStringField("toTime",
            toTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(toTime()));
        jsonWriter.writeBooleanField("groupByThrottlePolicy", groupByThrottlePolicy());
        jsonWriter.writeBooleanField("groupByOperationName", groupByOperationName());
        jsonWriter.writeBooleanField("groupByResourceName", groupByResourceName());
        jsonWriter.writeBooleanField("groupByClientApplicationId", groupByClientApplicationId());
        jsonWriter.writeBooleanField("groupByUserAgent", groupByUserAgent());
        jsonWriter.writeStringField("intervalLength",
            this.intervalLength == null ? null : this.intervalLength.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequestRateByIntervalInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequestRateByIntervalInput if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RequestRateByIntervalInput.
     */
    public static RequestRateByIntervalInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RequestRateByIntervalInput deserializedRequestRateByIntervalInput = new RequestRateByIntervalInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("blobContainerSasUri".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withBlobContainerSasUri(reader.getString());
                } else if ("fromTime".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withFromTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("toTime".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.withToTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("groupByThrottlePolicy".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput
                        .withGroupByThrottlePolicy(reader.getNullable(JsonReader::getBoolean));
                } else if ("groupByOperationName".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput
                        .withGroupByOperationName(reader.getNullable(JsonReader::getBoolean));
                } else if ("groupByResourceName".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput
                        .withGroupByResourceName(reader.getNullable(JsonReader::getBoolean));
                } else if ("groupByClientApplicationId".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput
                        .withGroupByClientApplicationId(reader.getNullable(JsonReader::getBoolean));
                } else if ("groupByUserAgent".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput
                        .withGroupByUserAgent(reader.getNullable(JsonReader::getBoolean));
                } else if ("intervalLength".equals(fieldName)) {
                    deserializedRequestRateByIntervalInput.intervalLength
                        = IntervalInMins.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRequestRateByIntervalInput;
        });
    }
}
