// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the gallery unique name.
 */
@Immutable
public final class GalleryIdentifier implements JsonSerializable<GalleryIdentifier> {
    /*
     * The unique name of the Shared Image Gallery. This name is generated automatically by Azure.
     */
    private String uniqueName;

    /**
     * Creates an instance of GalleryIdentifier class.
     */
    public GalleryIdentifier() {
    }

    /**
     * Get the uniqueName property: The unique name of the Shared Image Gallery. This name is generated automatically by
     * Azure.
     * 
     * @return the uniqueName value.
     */
    public String uniqueName() {
        return this.uniqueName;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryIdentifier from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryIdentifier if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryIdentifier.
     */
    public static GalleryIdentifier fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryIdentifier deserializedGalleryIdentifier = new GalleryIdentifier();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uniqueName".equals(fieldName)) {
                    deserializedGalleryIdentifier.uniqueName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryIdentifier;
        });
    }
}
