// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DedicatedHostInner;
import java.io.IOException;
import java.util.List;

/**
 * The list dedicated host operation response.
 */
@Fluent
public final class DedicatedHostListResult implements JsonSerializable<DedicatedHostListResult> {
    /*
     * The list of dedicated hosts
     */
    private List<DedicatedHostInner> value;

    /*
     * The URI to fetch the next page of dedicated hosts. Call ListNext() with this URI to fetch the next page of
     * dedicated hosts.
     */
    private String nextLink;

    /**
     * Creates an instance of DedicatedHostListResult class.
     */
    public DedicatedHostListResult() {
    }

    /**
     * Get the value property: The list of dedicated hosts.
     * 
     * @return the value value.
     */
    public List<DedicatedHostInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of dedicated hosts.
     * 
     * @param value the value value to set.
     * @return the DedicatedHostListResult object itself.
     */
    public DedicatedHostListResult withValue(List<DedicatedHostInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of dedicated hosts. Call ListNext() with this URI to
     * fetch the next page of dedicated hosts.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of dedicated hosts. Call ListNext() with this URI to
     * fetch the next page of dedicated hosts.
     * 
     * @param nextLink the nextLink value to set.
     * @return the DedicatedHostListResult object itself.
     */
    public DedicatedHostListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model DedicatedHostListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DedicatedHostListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DedicatedHostListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DedicatedHostListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DedicatedHostListResult.
     */
    public static DedicatedHostListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostListResult deserializedDedicatedHostListResult = new DedicatedHostListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DedicatedHostInner> value = reader.readArray(reader1 -> DedicatedHostInner.fromJson(reader1));
                    deserializedDedicatedHostListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDedicatedHostListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDedicatedHostListResult;
        });
    }
}
