/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryDiskImage;
import com.azure.resourcemanager.compute.models.GalleryDiskImageSource;
import com.azure.resourcemanager.compute.models.HostCaching;
import java.io.IOException;

public final class GalleryDataDiskImage
extends GalleryDiskImage {
    private int lun;
    private Integer sizeInGB;

    public int lun() {
        return this.lun;
    }

    public GalleryDataDiskImage withLun(int lun) {
        this.lun = lun;
        return this;
    }

    @Override
    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    @Override
    public GalleryDataDiskImage withHostCaching(HostCaching hostCaching) {
        super.withHostCaching(hostCaching);
        return this;
    }

    @Override
    public GalleryDataDiskImage withSource(GalleryDiskImageSource source) {
        super.withSource(source);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostCaching", this.hostCaching() == null ? null : this.hostCaching().toString());
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source());
        jsonWriter.writeIntField("lun", this.lun);
        return jsonWriter.writeEndObject();
    }

    public static GalleryDataDiskImage fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryDataDiskImage)jsonReader.readObject(reader -> {
            GalleryDataDiskImage deserializedGalleryDataDiskImage = new GalleryDataDiskImage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sizeInGB".equals(fieldName)) {
                    deserializedGalleryDataDiskImage.sizeInGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("hostCaching".equals(fieldName)) {
                    deserializedGalleryDataDiskImage.withHostCaching(HostCaching.fromString(reader.getString()));
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedGalleryDataDiskImage.withSource(GalleryDiskImageSource.fromJson(reader));
                    continue;
                }
                if ("lun".equals(fieldName)) {
                    deserializedGalleryDataDiskImage.lun = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryDataDiskImage;
        });
    }
}

