/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryApplicationCustomActionParameterType;
import java.io.IOException;

public final class GalleryApplicationCustomActionParameter
implements JsonSerializable<GalleryApplicationCustomActionParameter> {
    private String name;
    private Boolean required;
    private GalleryApplicationCustomActionParameterType type;
    private String defaultValue;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationCustomActionParameter.class);

    public String name() {
        return this.name;
    }

    public GalleryApplicationCustomActionParameter withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean required() {
        return this.required;
    }

    public GalleryApplicationCustomActionParameter withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public GalleryApplicationCustomActionParameterType type() {
        return this.type;
    }

    public GalleryApplicationCustomActionParameter withType(GalleryApplicationCustomActionParameterType type) {
        this.type = type;
        return this;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public GalleryApplicationCustomActionParameter withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GalleryApplicationCustomActionParameter withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model GalleryApplicationCustomActionParameter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("required", this.required);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("defaultValue", this.defaultValue);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static GalleryApplicationCustomActionParameter fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryApplicationCustomActionParameter)jsonReader.readObject(reader -> {
            GalleryApplicationCustomActionParameter deserializedGalleryApplicationCustomActionParameter = new GalleryApplicationCustomActionParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGalleryApplicationCustomActionParameter.name = reader.getString();
                    continue;
                }
                if ("required".equals(fieldName)) {
                    deserializedGalleryApplicationCustomActionParameter.required = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryApplicationCustomActionParameter.type = GalleryApplicationCustomActionParameterType.fromString(reader.getString());
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedGalleryApplicationCustomActionParameter.defaultValue = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGalleryApplicationCustomActionParameter.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryApplicationCustomActionParameter;
        });
    }
}

