/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.RestorePointEncryption;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;

public final class DiskRestorePointAttributes
extends SubResourceReadOnly {
    private RestorePointEncryption encryption;
    private ApiEntityReference sourceDiskRestorePoint;
    private String id;

    public RestorePointEncryption encryption() {
        return this.encryption;
    }

    public DiskRestorePointAttributes withEncryption(RestorePointEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public ApiEntityReference sourceDiskRestorePoint() {
        return this.sourceDiskRestorePoint;
    }

    public DiskRestorePointAttributes withSourceDiskRestorePoint(ApiEntityReference sourceDiskRestorePoint) {
        this.sourceDiskRestorePoint = sourceDiskRestorePoint;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.sourceDiskRestorePoint() != null) {
            this.sourceDiskRestorePoint().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeJsonField("sourceDiskRestorePoint", (JsonSerializable)this.sourceDiskRestorePoint);
        return jsonWriter.writeEndObject();
    }

    public static DiskRestorePointAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (DiskRestorePointAttributes)jsonReader.readObject(reader -> {
            DiskRestorePointAttributes deserializedDiskRestorePointAttributes = new DiskRestorePointAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDiskRestorePointAttributes.id = reader.getString();
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedDiskRestorePointAttributes.encryption = RestorePointEncryption.fromJson(reader);
                    continue;
                }
                if ("sourceDiskRestorePoint".equals(fieldName)) {
                    deserializedDiskRestorePointAttributes.sourceDiskRestorePoint = ApiEntityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskRestorePointAttributes;
        });
    }
}

