// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ShareInfoElement model.
 */
@Immutable
public final class ShareInfoElement implements JsonSerializable<ShareInfoElement> {
    /*
     * A relative URI containing the ID of the VM that has the disk attached.
     */
    private String vmUri;

    /**
     * Creates an instance of ShareInfoElement class.
     */
    public ShareInfoElement() {
    }

    /**
     * Get the vmUri property: A relative URI containing the ID of the VM that has the disk attached.
     * 
     * @return the vmUri value.
     */
    public String vmUri() {
        return this.vmUri;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ShareInfoElement from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ShareInfoElement if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ShareInfoElement.
     */
    public static ShareInfoElement fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ShareInfoElement deserializedShareInfoElement = new ShareInfoElement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vmUri".equals(fieldName)) {
                    deserializedShareInfoElement.vmUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedShareInfoElement;
        });
    }
}
