// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots.
 */
@Fluent
public final class KeyForDiskEncryptionSet implements JsonSerializable<KeyForDiskEncryptionSet> {
    /*
     * Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the
     * KeyVault subscription is not the same as the Disk Encryption Set subscription.
     */
    private SourceVault sourceVault;

    /*
     * Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of
     * rotationToLatestKeyVersionEnabled value.
     */
    private String keyUrl;

    /**
     * Creates an instance of KeyForDiskEncryptionSet class.
     */
    public KeyForDiskEncryptionSet() {
    }

    /**
     * Get the sourceVault property: Resource id of the KeyVault containing the key or secret. This property is optional
     * and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
     * 
     * @return the sourceVault value.
     */
    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: Resource id of the KeyVault containing the key or secret. This property is optional
     * and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the KeyForDiskEncryptionSet object itself.
     */
    public KeyForDiskEncryptionSet withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the keyUrl property: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is
     * required regardless of rotationToLatestKeyVersionEnabled value.
     * 
     * @return the keyUrl value.
     */
    public String keyUrl() {
        return this.keyUrl;
    }

    /**
     * Set the keyUrl property: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is
     * required regardless of rotationToLatestKeyVersionEnabled value.
     * 
     * @param keyUrl the keyUrl value to set.
     * @return the KeyForDiskEncryptionSet object itself.
     */
    public KeyForDiskEncryptionSet withKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceVault() != null) {
            sourceVault().validate();
        }
        if (keyUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property keyUrl in model KeyForDiskEncryptionSet"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyForDiskEncryptionSet.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyUrl", this.keyUrl);
        jsonWriter.writeJsonField("sourceVault", this.sourceVault);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyForDiskEncryptionSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyForDiskEncryptionSet if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyForDiskEncryptionSet.
     */
    public static KeyForDiskEncryptionSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyForDiskEncryptionSet deserializedKeyForDiskEncryptionSet = new KeyForDiskEncryptionSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyUrl".equals(fieldName)) {
                    deserializedKeyForDiskEncryptionSet.keyUrl = reader.getString();
                } else if ("sourceVault".equals(fieldName)) {
                    deserializedKeyForDiskEncryptionSet.sourceVault = SourceVault.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyForDiskEncryptionSet;
        });
    }
}
