/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.VirtualMachineExtensionHandlerInstanceView;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineAgentInstanceView
implements JsonSerializable<VirtualMachineAgentInstanceView> {
    private String vmAgentVersion;
    private List<VirtualMachineExtensionHandlerInstanceView> extensionHandlers;
    private List<InstanceViewStatus> statuses;

    public String vmAgentVersion() {
        return this.vmAgentVersion;
    }

    public VirtualMachineAgentInstanceView withVmAgentVersion(String vmAgentVersion) {
        this.vmAgentVersion = vmAgentVersion;
        return this;
    }

    public List<VirtualMachineExtensionHandlerInstanceView> extensionHandlers() {
        return this.extensionHandlers;
    }

    public VirtualMachineAgentInstanceView withExtensionHandlers(List<VirtualMachineExtensionHandlerInstanceView> extensionHandlers) {
        this.extensionHandlers = extensionHandlers;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public VirtualMachineAgentInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void validate() {
        if (this.extensionHandlers() != null) {
            this.extensionHandlers().forEach(e -> e.validate());
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmAgentVersion", this.vmAgentVersion);
        jsonWriter.writeArrayField("extensionHandlers", this.extensionHandlers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineAgentInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineAgentInstanceView)jsonReader.readObject(reader -> {
            VirtualMachineAgentInstanceView deserializedVirtualMachineAgentInstanceView = new VirtualMachineAgentInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmAgentVersion".equals(fieldName)) {
                    deserializedVirtualMachineAgentInstanceView.vmAgentVersion = reader.getString();
                    continue;
                }
                if ("extensionHandlers".equals(fieldName)) {
                    List extensionHandlers;
                    deserializedVirtualMachineAgentInstanceView.extensionHandlers = extensionHandlers = reader.readArray(reader1 -> VirtualMachineExtensionHandlerInstanceView.fromJson(reader1));
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedVirtualMachineAgentInstanceView.statuses = statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineAgentInstanceView;
        });
    }
}

