/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.DedicatedHostProperties;
import com.azure.resourcemanager.compute.models.DedicatedHostInstanceView;
import com.azure.resourcemanager.compute.models.DedicatedHostLicenseTypes;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class DedicatedHostInner
extends Resource {
    @JsonProperty(value="properties")
    private DedicatedHostProperties innerProperties;
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    private static final ClientLogger LOGGER = new ClientLogger(DedicatedHostInner.class);

    private DedicatedHostProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public DedicatedHostInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public DedicatedHostInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DedicatedHostInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer platformFaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomain();
    }

    public DedicatedHostInner withPlatformFaultDomain(Integer platformFaultDomain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withPlatformFaultDomain(platformFaultDomain);
        return this;
    }

    public Boolean autoReplaceOnFailure() {
        return this.innerProperties() == null ? null : this.innerProperties().autoReplaceOnFailure();
    }

    public DedicatedHostInner withAutoReplaceOnFailure(Boolean autoReplaceOnFailure) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withAutoReplaceOnFailure(autoReplaceOnFailure);
        return this;
    }

    public String hostId() {
        return this.innerProperties() == null ? null : this.innerProperties().hostId();
    }

    public List<SubResourceReadOnly> virtualMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachines();
    }

    public DedicatedHostLicenseTypes licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public DedicatedHostInner withLicenseType(DedicatedHostLicenseTypes licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public OffsetDateTime provisioningTime() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningTime();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DedicatedHostInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model DedicatedHostInner"));
        }
        this.sku().validate();
    }
}

