/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.Architecture;
import com.azure.resourcemanager.compute.models.CommunityGalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class CommunityGalleryImageProperties {
    @JsonProperty(value="osType", required=true)
    private OperatingSystemTypes osType;
    @JsonProperty(value="osState", required=true)
    private OperatingSystemStateTypes osState;
    @JsonProperty(value="endOfLifeDate")
    private OffsetDateTime endOfLifeDate;
    @JsonProperty(value="identifier", required=true)
    private CommunityGalleryImageIdentifier identifier;
    @JsonProperty(value="recommended")
    private RecommendedMachineConfiguration recommended;
    @JsonProperty(value="disallowed")
    private Disallowed disallowed;
    @JsonProperty(value="hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="features")
    private List<GalleryImageFeature> features;
    @JsonProperty(value="purchasePlan")
    private ImagePurchasePlan purchasePlan;
    @JsonProperty(value="architecture")
    private Architecture architecture;
    @JsonProperty(value="privacyStatementUri")
    private String privacyStatementUri;
    @JsonProperty(value="eula")
    private String eula;
    @JsonProperty(value="disclaimer")
    private String disclaimer;
    @JsonProperty(value="artifactTags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> artifactTags;
    private static final ClientLogger LOGGER = new ClientLogger(CommunityGalleryImageProperties.class);

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public CommunityGalleryImageProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public CommunityGalleryImageProperties withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public CommunityGalleryImageProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public CommunityGalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public CommunityGalleryImageProperties withIdentifier(CommunityGalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.recommended;
    }

    public CommunityGalleryImageProperties withRecommended(RecommendedMachineConfiguration recommended) {
        this.recommended = recommended;
        return this;
    }

    public Disallowed disallowed() {
        return this.disallowed;
    }

    public CommunityGalleryImageProperties withDisallowed(Disallowed disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public CommunityGalleryImageProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public List<GalleryImageFeature> features() {
        return this.features;
    }

    public CommunityGalleryImageProperties withFeatures(List<GalleryImageFeature> features) {
        this.features = features;
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    public CommunityGalleryImageProperties withPurchasePlan(ImagePurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public CommunityGalleryImageProperties withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public CommunityGalleryImageProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public CommunityGalleryImageProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public String disclaimer() {
        return this.disclaimer;
    }

    public CommunityGalleryImageProperties withDisclaimer(String disclaimer) {
        this.disclaimer = disclaimer;
        return this;
    }

    public Map<String, String> artifactTags() {
        return this.artifactTags;
    }

    public CommunityGalleryImageProperties withArtifactTags(Map<String, String> artifactTags) {
        this.artifactTags = artifactTags;
        return this;
    }

    public void validate() {
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model CommunityGalleryImageProperties"));
        }
        if (this.osState() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osState in model CommunityGalleryImageProperties"));
        }
        if (this.identifier() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property identifier in model CommunityGalleryImageProperties"));
        }
        this.identifier().validate();
        if (this.recommended() != null) {
            this.recommended().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
    }
}

