/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.CapacityReservationProperties;
import com.azure.resourcemanager.compute.models.CapacityReservationInstanceView;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class CapacityReservationInner
extends Resource {
    @JsonProperty(value="properties")
    private CapacityReservationProperties innerProperties;
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="zones")
    private List<String> zones;
    private static final ClientLogger LOGGER = new ClientLogger(CapacityReservationInner.class);

    private CapacityReservationProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public CapacityReservationInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public CapacityReservationInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public CapacityReservationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CapacityReservationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String reservationId() {
        return this.innerProperties() == null ? null : this.innerProperties().reservationId();
    }

    public Integer platformFaultDomainCount() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomainCount();
    }

    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachinesAssociated();
    }

    public OffsetDateTime provisioningTime() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningTime();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public CapacityReservationInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model CapacityReservationInner"));
        }
        this.sku().validate();
    }
}

