// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters for GenerateSshKeyPair.
 */
@Fluent
public final class SshGenerateKeyPairInputParameters {
    /*
     * The encryption type of the SSH keys to be generated. See SshEncryptionTypes for possible set of values. If not
     * provided, will default to RSA
     */
    @JsonProperty(value = "encryptionType")
    private SshEncryptionTypes encryptionType;

    /**
     * Creates an instance of SshGenerateKeyPairInputParameters class.
     */
    public SshGenerateKeyPairInputParameters() {
    }

    /**
     * Get the encryptionType property: The encryption type of the SSH keys to be generated. See SshEncryptionTypes for
     * possible set of values. If not provided, will default to RSA.
     * 
     * @return the encryptionType value.
     */
    public SshEncryptionTypes encryptionType() {
        return this.encryptionType;
    }

    /**
     * Set the encryptionType property: The encryption type of the SSH keys to be generated. See SshEncryptionTypes for
     * possible set of values. If not provided, will default to RSA.
     * 
     * @param encryptionType the encryptionType value to set.
     * @return the SshGenerateKeyPairInputParameters object itself.
     */
    public SshGenerateKeyPairInputParameters withEncryptionType(SshEncryptionTypes encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
